/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.jdbc.ExceptionSqlLogType;
import org.seasar.doma.jdbc.ResultMappingException;
import org.seasar.doma.jdbc.SqlKind;

public class ResultMappingExceptionTest
extends TestCase {
    public void test() throws Exception {
        ResultMappingException e = new ResultMappingException(ExceptionSqlLogType.FORMATTED_SQL, "aaa", Arrays.asList("bbb", "bbb2"), Arrays.asList("ccc", "ccc2"), SqlKind.SELECT, "ddd", "eee", "fff");
        System.out.println(e.getMessage());
        ResultMappingExceptionTest.assertEquals((String)"aaa", (String)e.getEntityClassName());
        List unmappedPropertyNames = e.getUnmappedPropertyNames();
        ResultMappingExceptionTest.assertEquals((String)"bbb", (String)((String)unmappedPropertyNames.get(0)));
        ResultMappingExceptionTest.assertEquals((String)"bbb2", (String)((String)unmappedPropertyNames.get(1)));
        List expectedColumnNames = e.getExpectedColumnNames();
        ResultMappingExceptionTest.assertEquals((String)"ccc", (String)((String)expectedColumnNames.get(0)));
        ResultMappingExceptionTest.assertEquals((String)"ccc2", (String)((String)expectedColumnNames.get(1)));
        ResultMappingExceptionTest.assertSame((Object)SqlKind.SELECT, (Object)e.getKind());
        ResultMappingExceptionTest.assertEquals((String)"ddd", (String)e.getRawSql());
        ResultMappingExceptionTest.assertEquals((String)"eee", (String)e.getFormattedSql());
        ResultMappingExceptionTest.assertEquals((String)"fff", (String)e.getSqlFilePath());
    }
}

