/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import junit.framework.TestCase;
import org.seasar.doma.internal.util.StringUtil;

public class StringUtilTest
extends TestCase {
    public void testCapitalize() throws Exception {
        StringUtilTest.assertEquals((String)"Aaa", (String)StringUtil.capitalize((String)"aaa"));
    }

    public void testDecapitalize() throws Exception {
        StringUtilTest.assertEquals((String)"aAA", (String)StringUtil.decapitalize((String)"AAA"));
    }

    public void testFromSnakeCaseToCamelCase() throws Exception {
        StringUtilTest.assertEquals((String)"aaaBbbCcc", (String)StringUtil.fromSnakeCaseToCamelCase((String)"AAA_BBB_CCC"));
        StringUtilTest.assertEquals((String)"aaaBbbCcc", (String)StringUtil.fromSnakeCaseToCamelCase((String)"aaa_bbb_ccc"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.fromSnakeCaseToCamelCase((String)"ABC"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.fromSnakeCaseToCamelCase((String)"abc"));
    }

    public void testFromCamelCaseToSnakeCase() throws Exception {
        StringUtilTest.assertEquals((String)"aaa_bbb_ccc", (String)StringUtil.fromCamelCaseToSnakeCase((String)"aaaBbbCcc"));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.fromCamelCaseToSnakeCase((String)"abc"));
    }

    public void testIsWhitespace() throws Exception {
        StringUtilTest.assertFalse((boolean)StringUtil.isWhitespace((String)""));
        StringUtilTest.assertTrue((boolean)StringUtil.isWhitespace((String)" "));
        StringUtilTest.assertTrue((boolean)StringUtil.isWhitespace((String)"  "));
        StringUtilTest.assertTrue((boolean)StringUtil.isWhitespace((String)" \t"));
    }

    public void testTrimWhitespace() throws Exception {
        StringUtilTest.assertEquals((String)"aaa", (String)StringUtil.trimWhitespace((String)" aaa "));
        StringUtilTest.assertEquals((String)"aaa", (String)StringUtil.trimWhitespace((String)"aaa "));
        StringUtilTest.assertEquals((String)"aaa", (String)StringUtil.trimWhitespace((String)"\raaa\n\t"));
        StringUtilTest.assertEquals((String)"aaa", (String)StringUtil.trimWhitespace((String)"aaa"));
    }
}

