/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class PreparedSqlBuilderTest
extends TestCase {
    private final MockConfig config = new MockConfig();

    public void testAppend() throws Exception {
        PreparedSqlBuilder builder = new PreparedSqlBuilder((Config)this.config, SqlKind.SELECT);
        builder.appendSql("select * from aaa where name = ");
        builder.appendWrapper((Wrapper)new StringWrapper("hoge"));
        builder.appendSql(" and salary = ");
        builder.appendWrapper((Wrapper)new BigDecimalWrapper(new BigDecimal(100)));
        PreparedSql sql = builder.build();
        PreparedSqlBuilderTest.assertEquals((String)"select * from aaa where name = ? and salary = ?", (String)sql.toString());
    }

    public void testCutBackSql() {
        PreparedSqlBuilder builder = new PreparedSqlBuilder((Config)this.config, SqlKind.SELECT);
        builder.appendSql("select * from aaa where name = ");
        builder.cutBackSql(14);
        PreparedSql sql = builder.build();
        PreparedSqlBuilderTest.assertEquals((String)"select * from aaa", (String)sql.toString());
    }
}

