/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import example.entity.Emp;
import example.entity._Emp;
import java.math.BigDecimal;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoInsertQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoInsertQueryTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testPrepare() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        AutoInsertQuery query = new AutoInsertQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        AutoInsertQuery insertQuery = query;
        AutoInsertQueryTest.assertNotNull((Object)insertQuery.getSql());
    }

    public void testOption_default() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        AutoInsertQuery query = new AutoInsertQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoInsertQueryTest.assertEquals((String)"insert into EMP (ID, NAME, SALARY, VERSION) values (?, ?, ?, ?)", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoInsertQueryTest.assertEquals((int)4, (int)parameters.size());
        AutoInsertQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoInsertQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoInsertQueryTest.assertNull((Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        AutoInsertQueryTest.assertEquals((Object)new Integer(1), (Object)((PreparedSqlParameter)parameters.get(3)).getWrapper().get());
    }

    public void testOption_excludeNull() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        AutoInsertQuery query = new AutoInsertQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setNullExcluded(true);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoInsertQueryTest.assertEquals((String)"insert into EMP (ID, NAME, VERSION) values (?, ?, ?)", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoInsertQueryTest.assertEquals((int)3, (int)parameters.size());
        AutoInsertQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoInsertQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoInsertQueryTest.assertEquals((Object)new Integer(1), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
    }

    public void testOption_include() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setSalary(new BigDecimal(200));
        AutoInsertQuery query = new AutoInsertQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setIncludedPropertyNames(new String[]{"name"});
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoInsertQueryTest.assertEquals((String)"insert into EMP (ID, NAME, VERSION) values (?, ?, ?)", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoInsertQueryTest.assertEquals((int)3, (int)parameters.size());
        AutoInsertQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoInsertQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoInsertQueryTest.assertEquals((Object)new Integer(1), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
    }

    public void testOption_exclude() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setSalary(new BigDecimal(200));
        AutoInsertQuery query = new AutoInsertQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setExcludedPropertyNames(new String[]{"name"});
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = query.getSql();
        AutoInsertQueryTest.assertEquals((String)"insert into EMP (ID, SALARY, VERSION) values (?, ?, ?)", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoInsertQueryTest.assertEquals((int)3, (int)parameters.size());
        AutoInsertQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoInsertQueryTest.assertEquals((Object)new BigDecimal(200), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        AutoInsertQueryTest.assertEquals((Object)new Integer(1), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
    }
}

