/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.entity.Emp;
import example.entity._Emp;
import java.math.BigDecimal;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.EntityResultListHandler;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.command.SelectCommand;
import org.seasar.doma.internal.jdbc.mock.BindValue;
import org.seasar.doma.internal.jdbc.mock.ColumnMetaData;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockConnection;
import org.seasar.doma.internal.jdbc.mock.MockPreparedStatement;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.MockResultSetMetaData;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileSelectQuery;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public class SelectCommandTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testExecute_singleResult() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("id"));
        metaData.columns.add(new ColumnMetaData("name"));
        metaData.columns.add(new ColumnMetaData("salary"));
        metaData.columns.add(new ColumnMetaData("version"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData(1, "hoge", new BigDecimal(10000), 100));
        this.runtimeConfig.dataSource.connection = new MockConnection(new MockPreparedStatement(resultSet));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.addParameter("name", String.class, (Object)"hoge");
        query.addParameter("salary", BigDecimal.class, (Object)new BigDecimal(10000));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        SelectCommand command = new SelectCommand((SelectQuery)query, (ResultSetHandler)new EntitySingleResultHandler((EntityType)_Emp.getSingletonInternal()));
        Emp entity = (Emp)command.execute();
        query.complete();
        SelectCommandTest.assertNotNull((Object)entity);
        SelectCommandTest.assertEquals((Object)new Integer(1), (Object)entity.getId());
        SelectCommandTest.assertEquals((String)"hoge", (String)entity.getName());
        SelectCommandTest.assertEquals((Object)new BigDecimal(10000), (Object)entity.getSalary());
        SelectCommandTest.assertEquals((Object)new Integer(100), (Object)entity.getVersion());
        List<BindValue> bindValues = this.runtimeConfig.dataSource.connection.preparedStatement.bindValues;
        BindValue bindValue = bindValues.get(0);
        SelectCommandTest.assertEquals((Object)"hoge", (Object)bindValue.getValue());
        SelectCommandTest.assertEquals((int)1, (int)bindValue.getIndex());
        bindValue = bindValues.get(1);
        SelectCommandTest.assertEquals((Object)new BigDecimal(10000), (Object)bindValue.getValue());
        SelectCommandTest.assertEquals((int)2, (int)bindValue.getIndex());
    }

    public void testExecute_resultList() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("id"));
        metaData.columns.add(new ColumnMetaData("name"));
        metaData.columns.add(new ColumnMetaData("salary"));
        metaData.columns.add(new ColumnMetaData("version"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData(1, "hoge", new BigDecimal(10000), 100));
        resultSet.rows.add(new RowData(2, "foo", new BigDecimal(20000), 200));
        resultSet.rows.add(new RowData(3, "bar", new BigDecimal(30000), 300));
        this.runtimeConfig.dataSource.connection = new MockConnection(new MockPreparedStatement(resultSet));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.addParameter("salary", BigDecimal.class, (Object)new BigDecimal(5000));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        SelectCommand command = new SelectCommand((SelectQuery)query, (ResultSetHandler)new EntityResultListHandler((EntityType)_Emp.getSingletonInternal()));
        List entities = (List)command.execute();
        query.complete();
        SelectCommandTest.assertNotNull((Object)entities);
        SelectCommandTest.assertEquals((int)3, (int)entities.size());
        Emp entity = (Emp)entities.get(0);
        SelectCommandTest.assertEquals((Object)new Integer(1), (Object)entity.getId());
        SelectCommandTest.assertEquals((String)"hoge", (String)entity.getName());
        SelectCommandTest.assertEquals((Object)new BigDecimal(10000), (Object)entity.getSalary());
        SelectCommandTest.assertEquals((Object)new Integer(100), (Object)entity.getVersion());
        entity = (Emp)entities.get(1);
        SelectCommandTest.assertEquals((Object)new Integer(2), (Object)entity.getId());
        SelectCommandTest.assertEquals((String)"foo", (String)entity.getName());
        SelectCommandTest.assertEquals((Object)new BigDecimal(20000), (Object)entity.getSalary());
        SelectCommandTest.assertEquals((Object)new Integer(200), (Object)entity.getVersion());
        entity = (Emp)entities.get(2);
        SelectCommandTest.assertEquals((Object)new Integer(3), (Object)entity.getId());
        SelectCommandTest.assertEquals((String)"bar", (String)entity.getName());
        SelectCommandTest.assertEquals((Object)new BigDecimal(30000), (Object)entity.getSalary());
        SelectCommandTest.assertEquals((Object)new Integer(300), (Object)entity.getVersion());
        List<BindValue> bindValues = this.runtimeConfig.dataSource.connection.preparedStatement.bindValues;
        BindValue bindValue = bindValues.get(0);
        bindValue = bindValues.get(0);
        SelectCommandTest.assertEquals((Object)new BigDecimal(5000), (Object)bindValue.getValue());
        SelectCommandTest.assertEquals((int)1, (int)bindValue.getIndex());
    }
}

