/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.domain.PhoneNumber;
import example.domain._PhoneNumber;
import java.sql.ResultSet;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.DomainIterationHandler;
import org.seasar.doma.internal.jdbc.mock.ColumnMetaData;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.MockResultSetMetaData;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileSelectQuery;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.IterationContext;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.domain.DomainType;

public class DomainIterationHandlerTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testHandle() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData("01-2345-6789"));
        resultSet.rows.add(new RowData("12-3456-7890"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        DomainIterationHandler handler = new DomainIterationHandler((DomainType)_PhoneNumber.getSingletonInternal(), (IterationCallback)new IterationCallback<String, PhoneNumber>(){
            private String result = "";

            public String iterate(PhoneNumber target, IterationContext iterationContext) {
                this.result = this.result + target.getValue();
                return this.result;
            }
        });
        String result = (String)handler.handle((ResultSet)resultSet, (SelectQuery)query);
        DomainIterationHandlerTest.assertEquals((String)"01-2345-678912-3456-7890", (String)result);
    }

    public void testHandle_exits() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData("01-2345-6789"));
        resultSet.rows.add(new RowData("12-3456-7890"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        DomainIterationHandler handler = new DomainIterationHandler((DomainType)_PhoneNumber.getSingletonInternal(), (IterationCallback)new IterationCallback<String, PhoneNumber>(){
            private String result = "";

            public String iterate(PhoneNumber target, IterationContext iterationContext) {
                this.result = this.result + target.getValue();
                iterationContext.exit();
                return this.result;
            }
        });
        String result = (String)handler.handle((ResultSet)resultSet, (SelectQuery)query);
        DomainIterationHandlerTest.assertEquals((String)"01-2345-6789", (String)result);
    }

    public void testHandle_NoResultException() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setResultEnsured(true);
        query.prepare();
        DomainIterationHandler handler = new DomainIterationHandler((DomainType)_PhoneNumber.getSingletonInternal(), (IterationCallback)new IterationCallback<String, PhoneNumber>(){
            private String result = "";

            public String iterate(PhoneNumber target, IterationContext iterationContext) {
                this.result = this.result + target.getValue();
                return this.result;
            }
        });
        try {
            handler.handle((ResultSet)resultSet, (SelectQuery)query);
            DomainIterationHandlerTest.fail();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }
}

