/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.entity.Emp;
import example.entity._Emp;
import java.math.BigDecimal;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.DeleteCommand;
import org.seasar.doma.internal.jdbc.mock.BindValue;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockConnection;
import org.seasar.doma.internal.jdbc.mock.MockPreparedStatement;
import org.seasar.doma.internal.jdbc.query.AutoDeleteQuery;
import org.seasar.doma.internal.jdbc.query.DeleteQuery;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.OptimisticLockException;
import org.seasar.doma.jdbc.entity.EntityType;

public class DeleteCommandTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testExecute() throws Exception {
        Emp emp = new Emp();
        emp.setId(1);
        emp.setName("hoge");
        emp.setSalary(new BigDecimal(1000));
        emp.setVersion(10);
        AutoDeleteQuery query = new AutoDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        int rows = new DeleteCommand((DeleteQuery)query).execute();
        query.complete();
        DeleteCommandTest.assertEquals((int)1, (int)rows);
        String sql = this.runtimeConfig.dataSource.connection.preparedStatement.sql;
        DeleteCommandTest.assertEquals((String)"delete from EMP where ID = ? and VERSION = ?", (String)sql);
        List<BindValue> bindValues = this.runtimeConfig.dataSource.connection.preparedStatement.bindValues;
        DeleteCommandTest.assertEquals((int)2, (int)bindValues.size());
        DeleteCommandTest.assertEquals((Object)new Integer(1), (Object)bindValues.get(0).getValue());
        DeleteCommandTest.assertEquals((Object)new Integer(10), (Object)bindValues.get(1).getValue());
    }

    public void testExecute_throwsOptimisticLockException() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setVersion(100);
        MockPreparedStatement ps = new MockPreparedStatement();
        ps.updatedRows = 0;
        this.runtimeConfig.dataSource.connection = new MockConnection(ps);
        AutoDeleteQuery query = new AutoDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        DeleteCommand command = new DeleteCommand((DeleteQuery)query);
        try {
            command.execute();
            DeleteCommandTest.fail();
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
    }

    public void testExecute_suppressesOptimisticLockException() throws Exception {
        Emp emp = new Emp();
        emp.setId(10);
        emp.setName("aaa");
        emp.setVersion(100);
        AutoDeleteQuery query = new AutoDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntity((Object)emp);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setOptimisticLockExceptionSuppressed(true);
        query.prepare();
        new DeleteCommand((DeleteQuery)query).execute();
        query.complete();
    }
}

