/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.entity.Emp;
import example.entity._Emp;
import java.util.Arrays;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.BatchUpdateCommand;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoBatchUpdateQuery;
import org.seasar.doma.internal.jdbc.query.BatchUpdateQuery;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.OptimisticLockException;
import org.seasar.doma.jdbc.entity.EntityType;

public class BatchUpdateCommandTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testExecute() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(1);
        emp1.setName("hoge");
        emp1.setVersion(10);
        Emp emp2 = new Emp();
        emp2.setId(2);
        emp2.setName("foo");
        emp2.setVersion(20);
        AutoBatchUpdateQuery query = new AutoBatchUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        int[] rows = new BatchUpdateCommand((BatchUpdateQuery)query).execute();
        query.complete();
        BatchUpdateCommandTest.assertEquals((int)2, (int)rows.length);
        String sql = this.runtimeConfig.dataSource.connection.preparedStatement.sql;
        BatchUpdateCommandTest.assertEquals((String)"update EMP set NAME = ?, SALARY = ?, VERSION = ? + 1 where ID = ? and VERSION = ?", (String)sql);
        BatchUpdateCommandTest.assertEquals((Object)new Integer(11), (Object)emp1.getVersion());
        BatchUpdateCommandTest.assertEquals((Object)new Integer(21), (Object)emp2.getVersion());
    }

    public void testExecute_throwsOptimisticLockException() throws Exception {
        Emp emp = new Emp();
        emp.setId(1);
        emp.setName("hoge");
        emp.setVersion(10);
        this.runtimeConfig.dataSource.connection.preparedStatement.updatedRows = 0;
        AutoBatchUpdateQuery query = new AutoBatchUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        BatchUpdateCommand command = new BatchUpdateCommand((BatchUpdateQuery)query);
        try {
            command.execute();
            BatchUpdateCommandTest.fail();
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
    }

    public void testExecute_suppressesOptimisticLockException() throws Exception {
        Emp emp = new Emp();
        emp.setId(1);
        emp.setName("hoge");
        emp.setVersion(10);
        this.runtimeConfig.dataSource.connection.preparedStatement.updatedRows = 0;
        AutoBatchUpdateQuery query = new AutoBatchUpdateQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp));
        query.setOptimisticLockExceptionSuppressed(true);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        new BatchUpdateCommand((BatchUpdateQuery)query).execute();
        query.complete();
    }
}

