/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.entity.Emp;
import example.entity._Emp;
import java.util.Arrays;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.BatchDeleteCommand;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoBatchDeleteQuery;
import org.seasar.doma.internal.jdbc.query.BatchDeleteQuery;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public class BatchDeleteCommandTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testExecute() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(1);
        emp1.setName("hoge");
        emp1.setVersion(10);
        Emp emp2 = new Emp();
        emp2.setId(2);
        emp2.setName("foo");
        emp2.setVersion(20);
        AutoBatchDeleteQuery query = new AutoBatchDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        int[] rows = new BatchDeleteCommand((BatchDeleteQuery)query).execute();
        query.complete();
        BatchDeleteCommandTest.assertEquals((int)2, (int)rows.length);
        String sql = this.runtimeConfig.dataSource.connection.preparedStatement.sql;
        BatchDeleteCommandTest.assertEquals((String)"delete from EMP where ID = ? and VERSION = ?", (String)sql);
    }
}

