/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.expr.EvaluationResult;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.ExpressionException;
import org.seasar.doma.internal.expr.node.ExpressionLocation;

public class ExpressionEvaluatorTest
extends TestCase {
    protected ExpressionLocation location = new ExpressionLocation("dummy expression", 0);

    public void testInvokeMethod() throws Exception {
        Class[] paramTypes = new Class[]{Integer.TYPE, Integer.TYPE};
        Method method = String.class.getMethod("substring", paramTypes);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult result = evaluator.invokeMethod(this.location, method, (Object)"abcde", String.class, paramTypes, new Object[]{2, 4});
        ExpressionEvaluatorTest.assertEquals((Object)"cd", (Object)result.getValue());
        ExpressionEvaluatorTest.assertEquals(String.class, (Object)result.getValueClass());
    }

    public void testFindMethod() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Method method = evaluator.findMethod("add", new ArrayList(), ArrayList.class, new Class[]{Object.class});
        ExpressionEvaluatorTest.assertNotNull((Object)method);
        ExpressionEvaluatorTest.assertEquals(Collection.class, method.getDeclaringClass());
    }

    public void testFindMethod_String_is_subtype_of_Object() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Method method = evaluator.findMethod("add", new ArrayList(), ArrayList.class, new Class[]{String.class});
        ExpressionEvaluatorTest.assertNotNull((Object)method);
        ExpressionEvaluatorTest.assertEquals(Collection.class, method.getDeclaringClass());
    }

    public void testFindMethod_List_is_subtype_of_Object() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Method method = evaluator.findMethod("add", new ArrayList(), ArrayList.class, new Class[]{List.class});
        ExpressionEvaluatorTest.assertNotNull((Object)method);
        ExpressionEvaluatorTest.assertEquals(Collection.class, method.getDeclaringClass());
    }

    public void testFindMethod_List_is_subtype_of_Collection() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Method method = evaluator.findMethod("addAll", new ArrayList(), ArrayList.class, new Class[]{List.class});
        ExpressionEvaluatorTest.assertNotNull((Object)method);
        ExpressionEvaluatorTest.assertEquals(Collection.class, method.getDeclaringClass());
    }

    public void testFindMethod_overload_int() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Method method = evaluator.findMethod("indexOf", (Object)"string", String.class, new Class[]{Integer.TYPE});
        ExpressionEvaluatorTest.assertNotNull((Object)method);
        ExpressionEvaluatorTest.assertEquals(String.class, method.getDeclaringClass());
    }

    public void testFindMethod_overload_string() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Method method = evaluator.findMethod("indexOf", (Object)"string", String.class, new Class[]{String.class});
        ExpressionEvaluatorTest.assertNotNull((Object)method);
        ExpressionEvaluatorTest.assertEquals(String.class, method.getDeclaringClass());
    }

    public void testFindMethod_autoBoxing() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Method method = evaluator.findMethod("compareTo", (Object)1, Integer.class, new Class[]{Integer.TYPE});
        ExpressionEvaluatorTest.assertNotNull((Object)method);
        ExpressionEvaluatorTest.assertEquals(Integer.class, method.getDeclaringClass());
    }

    public void testFindMethod_notFound() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Method method = evaluator.findMethod("inexistentMethod", (Object)"aaa", String.class, new Class[]{String.class});
        ExpressionEvaluatorTest.assertNull((Object)method);
    }

    public void testForClassName() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Class clazz = evaluator.forClassName(this.location, "java.lang.String");
        ExpressionEvaluatorTest.assertNotNull((Object)clazz);
    }

    public void testForClassName_notFound() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        try {
            evaluator.forClassName(this.location, "inexistentClass");
        }
        catch (ExpressionException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    public void testFindConstructor() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Constructor constructor = evaluator.findConstructor(this.location, String.class, new Class[]{char[].class, Integer.TYPE, Integer.TYPE});
        ExpressionEvaluatorTest.assertNotNull((Object)constructor);
    }

    public void testFindConstructor_notFound() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Constructor constructor = evaluator.findConstructor(this.location, String.class, new Class[]{Integer.TYPE, Integer.TYPE});
        ExpressionEvaluatorTest.assertNull((Object)constructor);
    }

    public void testInvokeConstructor() throws Exception {
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        Constructor constructor = evaluator.findConstructor(this.location, String.class, new Class[]{char[].class, Integer.TYPE, Integer.TYPE});
        EvaluationResult result = evaluator.invokeConstructor(this.location, String.class, constructor, new Object[]{new char[]{'a', 'b', 'c'}, 1, 2});
        ExpressionEvaluatorTest.assertEquals((Object)"bc", (Object)result.getValue());
        ExpressionEvaluatorTest.assertEquals(String.class, (Object)result.getValueClass());
    }
}

