/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr.node;

import junit.framework.TestCase;
import org.seasar.doma.internal.expr.EvaluationResult;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.node.ExpressionLocation;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.expr.node.LiteralNode;
import org.seasar.doma.internal.expr.node.NotOperatorNode;

public class NotOperatorNodeTest
extends TestCase {
    protected ExpressionLocation location = new ExpressionLocation("", 0);
    protected LiteralNode trueLiteral = new LiteralNode(this.location, "true", (Object)true, Boolean.TYPE);
    protected LiteralNode falseLiteral = new LiteralNode(this.location, "false", (Object)false, Boolean.TYPE);
    protected LiteralNode nullLiteral = new LiteralNode(this.location, "null", null, Object.class);

    public void test_true() throws Exception {
        NotOperatorNode node = new NotOperatorNode(this.location, "!");
        node.setNode((ExpressionNode)this.trueLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        NotOperatorNodeTest.assertFalse((boolean)evaluationResult.getBooleanValue());
    }

    public void test_false() throws Exception {
        NotOperatorNode node = new NotOperatorNode(this.location, "!");
        node.setNode((ExpressionNode)this.falseLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        NotOperatorNodeTest.assertTrue((boolean)evaluationResult.getBooleanValue());
    }

    public void test_null() throws Exception {
        NotOperatorNode node = new NotOperatorNode(this.location, "!");
        node.setNode((ExpressionNode)this.nullLiteral);
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        EvaluationResult evaluationResult = evaluator.evaluate((ExpressionNode)node);
        NotOperatorNodeTest.assertTrue((boolean)evaluationResult.getBooleanValue());
    }
}

