/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.SqlFileSelectQueryMeta;
import org.seasar.doma.internal.apt.mirror.SelectMirror;
import org.seasar.doma.internal.apt.type.AnyType;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.IterableType;
import org.seasar.doma.internal.apt.type.IterationCallbackType;
import org.seasar.doma.internal.apt.type.MapType;
import org.seasar.doma.internal.apt.type.SelectOptionsType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileSelectQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileSelectQueryMeta> {
    public SqlFileSelectQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        SqlFileSelectQueryMeta queryMeta = this.createSqlFileSelectQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        this.doSqlFiles(queryMeta, method, daoMeta);
        return queryMeta;
    }

    protected SqlFileSelectQueryMeta createSqlFileSelectQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        SelectMirror selectMirror = SelectMirror.newInstance(method, this.env);
        if (selectMirror == null) {
            return null;
        }
        SqlFileSelectQueryMeta queryMeta = new SqlFileSelectQueryMeta(method);
        queryMeta.setSelectMirror(selectMirror);
        queryMeta.setQueryKind(QueryKind.SQLFILE_SELECT);
        return queryMeta;
    }

    @Override
    protected void doReturnType(final SqlFileSelectQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        final QueryReturnMeta returnMeta = this.createReturnMeta(method);
        queryMeta.setReturnMeta(returnMeta);
        if (queryMeta.getIterate()) {
            IterationCallbackType iterationCallbackType = queryMeta.getIterationCallbackType();
            AnyType callbackReturnType = iterationCallbackType.getReturnType();
            if (callbackReturnType == null || !this.env.getTypeUtils().isSameType(returnMeta.getType(), callbackReturnType.getTypeMirror())) {
                throw new AptException((MessageResource)Message.DOMA4055, this.env, (Element)method, returnMeta.getType(), callbackReturnType.getTypeNameAsTypeParameter());
            }
            DataType callbackTargetType = iterationCallbackType.getTargetType();
            callbackTargetType.accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                protected Void defaultAction(DataType type, Void p) throws RuntimeException {
                    throw new AptException((MessageResource)Message.DOMA4058, SqlFileSelectQueryMetaFactory.this.env, (Element)queryMeta.getExecutableElement(), new Object[0]);
                }

                @Override
                public Void visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                    return null;
                }

                @Override
                public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                    return null;
                }

                @Override
                public Void visitMapType(MapType dataType, Void p) throws RuntimeException {
                    return null;
                }

                @Override
                public Void visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                    return null;
                }
            }, null);
        } else {
            returnMeta.getDataType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                protected Void defaultAction(DataType type, Void p) throws RuntimeException {
                    throw new AptException((MessageResource)Message.DOMA4008, SqlFileSelectQueryMetaFactory.this.env, (Element)returnMeta.getElement(), returnMeta.getType());
                }

                @Override
                public Void visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                    return null;
                }

                @Override
                public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                    return null;
                }

                @Override
                public Void visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                    if (dataType.isAbstract()) {
                        throw new AptException((MessageResource)Message.DOMA4154, SqlFileSelectQueryMetaFactory.this.env, (Element)returnMeta.getElement(), dataType.getQualifiedName());
                    }
                    return null;
                }

                @Override
                public Void visitMapType(MapType dataType, Void p) throws RuntimeException {
                    return null;
                }

                @Override
                public Void visitIterableType(IterableType dataType, Void p) throws RuntimeException {
                    if (!dataType.isList()) {
                        this.defaultAction((DataType)dataType, p);
                    }
                    dataType.getElementType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                        @Override
                        protected Void defaultAction(DataType type, Void p) throws RuntimeException {
                            throw new AptException((MessageResource)Message.DOMA4007, SqlFileSelectQueryMetaFactory.this.env, (Element)returnMeta.getElement(), type.getTypeName());
                        }

                        @Override
                        public Void visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                            return null;
                        }

                        @Override
                        public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                            return null;
                        }

                        @Override
                        public Void visitMapType(MapType dataType, Void p) throws RuntimeException {
                            return null;
                        }

                        @Override
                        public Void visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                            if (dataType.isAbstract()) {
                                throw new AptException((MessageResource)Message.DOMA4155, SqlFileSelectQueryMetaFactory.this.env, (Element)returnMeta.getElement(), dataType.getTypeMirror());
                            }
                            return null;
                        }
                    }, p);
                    return null;
                }
            }, null);
        }
    }

    @Override
    protected void doParameters(final SqlFileSelectQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        for (VariableElement variableElement : method.getParameters()) {
            final QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement);
            parameterMeta.getDataType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitIterationCallbackType(IterationCallbackType dataType, Void p) throws RuntimeException {
                    if (queryMeta.getIterationCallbackType() != null) {
                        throw new AptException((MessageResource)Message.DOMA4054, SqlFileSelectQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), new Object[0]);
                    }
                    dataType.getTargetType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                        @Override
                        public Void visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                            if (dataType.isAbstract()) {
                                throw new AptException((MessageResource)Message.DOMA4158, SqlFileSelectQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), dataType.getTypeName());
                            }
                            return null;
                        }
                    }, null);
                    queryMeta.setIterationCallbackType(dataType);
                    queryMeta.setIterationCallbackPrameterName(parameterMeta.getName());
                    return null;
                }

                @Override
                public Void visitSelectOptionsType(SelectOptionsType dataType, Void p) throws RuntimeException {
                    if (queryMeta.getSelectOptionsType() != null) {
                        throw new AptException((MessageResource)Message.DOMA4053, SqlFileSelectQueryMetaFactory.this.env, (Element)parameterMeta.getElement(), new Object[0]);
                    }
                    queryMeta.setSelectOptionsType(dataType);
                    queryMeta.setSelectOptionsParameterName(parameterMeta.getName());
                    return null;
                }
            }, null);
            queryMeta.addParameterMeta(parameterMeta);
            if (!parameterMeta.isBindable()) continue;
            queryMeta.addBindableParameterType(parameterMeta.getName(), parameterMeta.getType());
        }
        if (queryMeta.getIterate()) {
            if (queryMeta.getIterationCallbackType() == null) {
                throw new AptException((MessageResource)Message.DOMA4056, this.env, (Element)method, new Object[0]);
            }
        } else if (queryMeta.getIterationCallbackType() != null) {
            SelectMirror selectMirror = queryMeta.getSelectMirror();
            throw new AptException((MessageResource)Message.DOMA4057, this.env, (Element)method, selectMirror.getAnnotationMirror(), selectMirror.getIterate(), new Object[0]);
        }
    }
}

