/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import example.entity.Emp;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.SqlFileBatchDeleteQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.jdbc.Config;

public class SqlFileBatchDeleteQueryTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testPrepare() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        emp1.setVersion(100);
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setName("bbb");
        emp2.setVersion(200);
        SqlFileBatchDeleteQuery query = new SqlFileBatchDeleteQuery(Emp.class);
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setParameterName("e");
        query.setElements(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        SqlFileBatchDeleteQuery batchDeleteQuery = query;
        SqlFileBatchDeleteQueryTest.assertEquals((int)2, (int)batchDeleteQuery.getSqls().size());
    }

    public void testOption_default() throws Exception {
        Emp emp1 = new Emp();
        emp1.setName("aaa");
        Emp emp2 = new Emp();
        emp2.setName("bbb");
        SqlFileBatchDeleteQuery query = new SqlFileBatchDeleteQuery(Emp.class);
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setParameterName("e");
        query.setElements(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = (PreparedSql)query.getSqls().get(0);
        SqlFileBatchDeleteQueryTest.assertEquals((String)"delete from emp where name = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        SqlFileBatchDeleteQueryTest.assertEquals((int)1, (int)parameters.size());
        SqlFileBatchDeleteQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        sql = (PreparedSql)query.getSqls().get(1);
        SqlFileBatchDeleteQueryTest.assertEquals((String)"delete from emp where name = ?", (String)sql.getRawSql());
        parameters = sql.getParameters();
        SqlFileBatchDeleteQueryTest.assertEquals((int)1, (int)parameters.size());
        SqlFileBatchDeleteQueryTest.assertEquals((Object)"bbb", (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
    }
}

