/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import example.entity.Emp;
import example.entity._Emp;
import java.sql.ResultSet;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.mock.ColumnMetaData;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.MockResultSetMetaData;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileSelectQuery;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.NonUniqueResultException;
import org.seasar.doma.jdbc.entity.EntityType;

public class EntitySingleResultHandlerTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testHandle() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("id"));
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData(1, "aaa"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        EntitySingleResultHandler handler = new EntitySingleResultHandler((EntityType)_Emp.getSingletonInternal());
        Emp emp = (Emp)handler.handle((ResultSet)resultSet, (SelectQuery)query);
        EntitySingleResultHandlerTest.assertEquals((Object)new Integer(1), (Object)emp.getId());
        EntitySingleResultHandlerTest.assertEquals((String)"aaa", (String)emp.getName());
    }

    public void testHandle_NonUniqueResultException() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("id"));
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData(1, "aaa"));
        resultSet.rows.add(new RowData(2, "bbb"));
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        EntitySingleResultHandler handler = new EntitySingleResultHandler((EntityType)_Emp.getSingletonInternal());
        try {
            handler.handle((ResultSet)resultSet, (SelectQuery)query);
            EntitySingleResultHandlerTest.fail();
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            // empty catch block
        }
    }

    public void testHandle_NoResultException() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("id"));
        metaData.columns.add(new ColumnMetaData("name"));
        MockResultSet resultSet = new MockResultSet(metaData);
        SqlFileSelectQuery query = new SqlFileSelectQuery();
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.setResultEnsured(true);
        query.prepare();
        EntitySingleResultHandler handler = new EntitySingleResultHandler((EntityType)_Emp.getSingletonInternal());
        try {
            handler.handle((ResultSet)resultSet, (SelectQuery)query);
            EntitySingleResultHandlerTest.fail();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }
}

