/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import example.entity.Emp;
import junit.framework.TestCase;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.DefaultClassHelper;
import org.seasar.doma.jdbc.entity.Dept;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.EntityTypeFactory;
import org.seasar.doma.jdbc.entity.EntityTypeNotFoundException;

public class EntityTypeFactoryTest
extends TestCase {
    public void testGetEntityType() throws Exception {
        EntityType type = EntityTypeFactory.getEntityType(Emp.class, (ClassHelper)new DefaultClassHelper());
        EntityTypeFactoryTest.assertNotNull((Object)type);
    }

    public void testGetEntityType_DomaIllegalArgumentException() throws Exception {
        try {
            EntityTypeFactory.getEntityType(Object.class, (ClassHelper)new DefaultClassHelper());
            EntityTypeFactoryTest.fail();
        }
        catch (DomaIllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    public void testGetEntityType_EntityTypeNotFoundException() throws Exception {
        try {
            EntityTypeFactory.getEntityType(Dept.class, (ClassHelper)new DefaultClassHelper());
            EntityTypeFactoryTest.fail();
        }
        catch (EntityTypeNotFoundException e) {
            System.out.println(e.getMessage());
        }
    }
}

