/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import example.entity.Emp;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.SqlFileBatchInsertQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.jdbc.Config;

public class SqlFileBatchInsertQueryTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testPrepare() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        emp1.setVersion(100);
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setName("bbb");
        emp2.setVersion(200);
        SqlFileBatchInsertQuery query = new SqlFileBatchInsertQuery(Emp.class);
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setParameterName("e");
        query.setElements(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        SqlFileBatchInsertQuery batchInsertQuery = query;
        SqlFileBatchInsertQueryTest.assertEquals((int)2, (int)batchInsertQuery.getSqls().size());
    }

    public void testOption_default() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        emp1.setVersion(100);
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setSalary(new BigDecimal(2000));
        emp2.setVersion(200);
        SqlFileBatchInsertQuery query = new SqlFileBatchInsertQuery(Emp.class);
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setSqlFilePath(SqlFileUtil.buildPath((String)((Object)((Object)this)).getClass().getName(), (String)this.getName()));
        query.setParameterName("e");
        query.setElements(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = (PreparedSql)query.getSqls().get(0);
        SqlFileBatchInsertQueryTest.assertEquals((String)"insert into emp (id, name, salary) values (?, ?, ?)", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        SqlFileBatchInsertQueryTest.assertEquals((int)3, (int)parameters.size());
        SqlFileBatchInsertQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        SqlFileBatchInsertQueryTest.assertEquals((Object)"aaa", (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        SqlFileBatchInsertQueryTest.assertNull((Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
        sql = (PreparedSql)query.getSqls().get(1);
        SqlFileBatchInsertQueryTest.assertEquals((String)"insert into emp (id, name, salary) values (?, ?, ?)", (String)sql.getRawSql());
        parameters = sql.getParameters();
        SqlFileBatchInsertQueryTest.assertEquals((int)3, (int)parameters.size());
        SqlFileBatchInsertQueryTest.assertEquals((Object)new Integer(20), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        SqlFileBatchInsertQueryTest.assertNull((Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
        SqlFileBatchInsertQueryTest.assertEquals((Object)new BigDecimal(2000), (Object)((PreparedSqlParameter)parameters.get(2)).getWrapper().get());
    }
}

