/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.mock;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.RowData;

public class MockResultSetTest
extends TestCase {
    public void testNext() throws Exception {
        MockResultSet resultSet = new MockResultSet();
        resultSet.rows.add(new RowData("aaa"));
        resultSet.rows.add(new RowData("bbb"));
        MockResultSetTest.assertTrue((boolean)resultSet.next());
        MockResultSetTest.assertEquals((String)"aaa", (String)resultSet.getString(1));
        MockResultSetTest.assertTrue((boolean)resultSet.next());
        MockResultSetTest.assertEquals((String)"bbb", (String)resultSet.getString(1));
        MockResultSetTest.assertFalse((boolean)resultSet.next());
    }

    public void testGetString() throws Exception {
        MockResultSet resultSet = new MockResultSet();
        resultSet.rows.add(new RowData("aaa", "bbb"));
        MockResultSetTest.assertTrue((boolean)resultSet.next());
        MockResultSetTest.assertEquals((String)"aaa", (String)resultSet.getString(1));
        MockResultSetTest.assertEquals((String)"bbb", (String)resultSet.getString(2));
    }

    public void testGetInteger() throws Exception {
        MockResultSet resultSet = new MockResultSet();
        resultSet.rows.add(new RowData(10, 20));
        MockResultSetTest.assertTrue((boolean)resultSet.next());
        MockResultSetTest.assertEquals((int)10, (int)resultSet.getInt(1));
        MockResultSetTest.assertEquals((int)20, (int)resultSet.getInt(2));
    }

    public void testGetBigDecimal() throws Exception {
        MockResultSet resultSet = new MockResultSet();
        resultSet.rows.add(new RowData(new BigDecimal(10), new BigDecimal(20)));
        MockResultSetTest.assertTrue((boolean)resultSet.next());
        MockResultSetTest.assertEquals((Object)new BigDecimal(10), (Object)resultSet.getBigDecimal(1));
        MockResultSetTest.assertEquals((Object)new BigDecimal(20), (Object)resultSet.getBigDecimal(2));
    }
}

