/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.command.BasicFetcher;
import org.seasar.doma.internal.jdbc.mock.ColumnMetaData;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.mock.MockResultSet;
import org.seasar.doma.internal.jdbc.mock.MockResultSetMetaData;
import org.seasar.doma.internal.jdbc.mock.RowData;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class BasicFetcherTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testFetchDomain() throws Exception {
        MockResultSetMetaData metaData = new MockResultSetMetaData();
        metaData.columns.add(new ColumnMetaData("aaa"));
        MockResultSet resultSet = new MockResultSet(metaData);
        resultSet.rows.add(new RowData("hoge"));
        resultSet.next();
        StringWrapper wrapper = new StringWrapper();
        BasicFetcher fetcher = new BasicFetcher((Query)new MySelectQuery());
        fetcher.fetch((ResultSet)resultSet, (Wrapper)wrapper);
        BasicFetcherTest.assertEquals((String)"hoge", (String)((String)wrapper.get()));
    }

    protected class MySelectQuery
    implements SelectQuery {
        protected MySelectQuery() {
        }

        public SelectOptions getOptions() {
            return SelectOptions.get();
        }

        public Config getConfig() {
            return BasicFetcherTest.this.runtimeConfig;
        }

        public String getClassName() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public PreparedSql getSql() {
            return null;
        }

        public boolean isResultEnsured() {
            return false;
        }

        public boolean isResultMappingEnsured() {
            return false;
        }

        public int getFetchSize() {
            return 0;
        }

        public int getMaxRows() {
            return 0;
        }

        public int getQueryTimeout() {
            return 0;
        }

        public void prepare() {
        }

        public void complete() {
        }
    }
}

