/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.command.UpdateCommand;
import org.seasar.doma.internal.jdbc.query.SqlUpdateQuery;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.builder.BuildingHelper;
import org.seasar.doma.jdbc.builder.Param;
import org.seasar.doma.jdbc.builder.ParamIndex;

public class UpdateBuilder {
    private final BuildingHelper helper;
    private final SqlUpdateQuery query;
    private final ParamIndex paramIndex;

    private UpdateBuilder(Config config) {
        this.helper = new BuildingHelper();
        this.query = new SqlUpdateQuery();
        this.query.setConfig(config);
        this.query.setCallerClassName(this.getClass().getName());
        this.paramIndex = new ParamIndex();
    }

    private UpdateBuilder(BuildingHelper builder, SqlUpdateQuery query, ParamIndex parameterIndex) {
        this.helper = builder;
        this.query = query;
        this.paramIndex = parameterIndex;
    }

    public static UpdateBuilder newInstance(Config config) {
        if (config == null) {
            throw new DomaNullPointerException("config");
        }
        return new UpdateBuilder(config);
    }

    public UpdateBuilder sql(String sql) {
        if (sql == null) {
            throw new DomaNullPointerException("sql");
        }
        this.helper.appendSqlWithLineSeparator(sql);
        return new SubsequentUpdateBuilder(this.helper, this.query, this.paramIndex);
    }

    public UpdateBuilder removeLast() {
        this.helper.removeLast();
        return new SubsequentUpdateBuilder(this.helper, this.query, this.paramIndex);
    }

    public <P> UpdateBuilder param(Class<P> paramClass, P param) {
        if (paramClass == null) {
            throw new DomaNullPointerException("paramClass");
        }
        this.helper.appendParam(new Param(paramClass, param, this.paramIndex));
        this.paramIndex.increment();
        return new SubsequentUpdateBuilder(this.helper, this.query, this.paramIndex);
    }

    public int execute() {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("execute");
        }
        for (Param p : this.helper.getParams()) {
            this.query.addParameter(p.name, p.paramClass, p.param);
        }
        this.query.setSqlNode(this.helper.getSqlNode());
        this.query.prepare();
        UpdateCommand command = new UpdateCommand(this.query);
        int result = command.execute();
        this.query.complete();
        return result;
    }

    public void queryTimeout(int queryTimeout) {
        this.query.setQueryTimeout(queryTimeout);
    }

    public void callerClassName(String className) {
        if (className == null) {
            throw new DomaNullPointerException("className");
        }
        this.query.setCallerClassName(className);
    }

    public void callerMethodName(String methodName) {
        if (methodName == null) {
            throw new DomaNullPointerException("methodName");
        }
        this.query.setCallerMethodName(methodName);
    }

    public Sql<?> getSql() {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getSql");
        }
        this.query.setSqlNode(this.helper.getSqlNode());
        this.query.prepare();
        return this.query.getSql();
    }

    private static class SubsequentUpdateBuilder
    extends UpdateBuilder {
        private SubsequentUpdateBuilder(BuildingHelper builder, SqlUpdateQuery query, ParamIndex parameterIndex) {
            super(builder, query, parameterIndex);
        }

        @Override
        public UpdateBuilder sql(String sql) {
            if (sql == null) {
                throw new DomaNullPointerException("sql");
            }
            ((UpdateBuilder)this).helper.appendSql(sql);
            return this;
        }
    }
}

