/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.seasar.framework.util.BigDecimalConversionUtil;
import org.seasar.framework.util.BigIntegerConversionUtil;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.ByteConversionUtil;
import org.seasar.framework.util.DecimalFormatSymbolsUtil;
import org.seasar.framework.util.DoubleConversionUtil;
import org.seasar.framework.util.FloatConversionUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.ShortConversionUtil;
import org.seasar.framework.util.StringUtil;

public class NumberConversionUtil {
    protected NumberConversionUtil() {
    }

    public static Object convertNumber(Class type, Object o) {
        if (type == Integer.class) {
            return IntegerConversionUtil.toInteger(o);
        }
        if (type == BigDecimal.class) {
            return BigDecimalConversionUtil.toBigDecimal(o);
        }
        if (type == Double.class) {
            return DoubleConversionUtil.toDouble(o);
        }
        if (type == Long.class) {
            return LongConversionUtil.toLong(o);
        }
        if (type == Float.class) {
            return FloatConversionUtil.toFloat(o);
        }
        if (type == Short.class) {
            return ShortConversionUtil.toShort(o);
        }
        if (type == BigInteger.class) {
            return BigIntegerConversionUtil.toBigInteger(o);
        }
        if (type == Byte.class) {
            return ByteConversionUtil.toByte(o);
        }
        return o;
    }

    public static Object convertPrimitiveWrapper(Class type, Object o) {
        if (type == Integer.TYPE) {
            Integer i = IntegerConversionUtil.toInteger(o);
            if (i != null) {
                return i;
            }
            return new Integer(0);
        }
        if (type == Double.TYPE) {
            Double d = DoubleConversionUtil.toDouble(o);
            if (d != null) {
                return d;
            }
            return new Double(0.0);
        }
        if (type == Long.TYPE) {
            Long l = LongConversionUtil.toLong(o);
            if (l != null) {
                return l;
            }
            return new Long(0L);
        }
        if (type == Float.TYPE) {
            Float f = FloatConversionUtil.toFloat(o);
            if (f != null) {
                return f;
            }
            return new Float(0.0f);
        }
        if (type == Short.TYPE) {
            Short s = ShortConversionUtil.toShort(o);
            if (s != null) {
                return s;
            }
            return new Short(0);
        }
        if (type == Boolean.TYPE) {
            Boolean b = BooleanConversionUtil.toBoolean(o);
            if (b != null) {
                return b;
            }
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            Byte b = ByteConversionUtil.toByte(o);
            if (b != null) {
                return b;
            }
            return new Byte(0);
        }
        return o;
    }

    public static String removeDelimeter(String value, Locale locale) {
        String groupingSeparator = NumberConversionUtil.findGroupingSeparator(locale);
        if (groupingSeparator != null) {
            value = StringUtil.replace(value, groupingSeparator, "");
        }
        return value;
    }

    public static String findGroupingSeparator(Locale locale) {
        DecimalFormatSymbols symbol = NumberConversionUtil.getDecimalFormatSymbols(locale);
        return Character.toString(symbol.getGroupingSeparator());
    }

    public static String findDecimalSeparator(Locale locale) {
        DecimalFormatSymbols symbol = NumberConversionUtil.getDecimalFormatSymbols(locale);
        return Character.toString(symbol.getDecimalSeparator());
    }

    private static DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
        DecimalFormatSymbols symbol = locale != null ? DecimalFormatSymbolsUtil.getDecimalFormatSymbols(locale) : DecimalFormatSymbolsUtil.getDecimalFormatSymbols();
        return symbol;
    }
}

