/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.meta.IdGeneratorMeta;
import org.seasar.doma.internal.apt.mirror.ColumnMirror;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.util.MetaUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.NamingType;

public class EntityPropertyMeta {
    protected final String entityName;
    protected final String entityTypeName;
    protected final String entityMetaTypeName;
    protected final NamingType namingType;
    protected final TypeMirror type;
    protected final String typeName;
    protected final boolean ownProperty;
    protected final String fieldPrefix;
    protected String name;
    protected boolean id;
    protected boolean version;
    protected ColumnMirror columnMirror;
    protected IdGeneratorMeta idGeneratorMeta;
    protected DataType dataType;

    public EntityPropertyMeta(TypeElement entityElement, VariableElement propertyElement, NamingType namingType, boolean ownProperty, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)entityElement, (Object)propertyElement, (Object)namingType, (Object)env);
        this.entityName = entityElement.getSimpleName().toString();
        this.entityTypeName = entityElement.getQualifiedName().toString();
        this.entityMetaTypeName = MetaUtil.getMetaTypeName(this.entityTypeName);
        this.namingType = namingType;
        this.type = propertyElement.asType();
        this.typeName = TypeMirrorUtil.getTypeName(this.type, env);
        this.ownProperty = ownProperty;
        this.fieldPrefix = Options.getEntityFieldPrefix(env);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public String getEntityMetaTypeName() {
        return this.entityMetaTypeName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFieldName() {
        return this.fieldPrefix + this.name;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public IdGeneratorMeta getIdGeneratorMeta() {
        return this.idGeneratorMeta;
    }

    public void setIdGeneratorMeta(IdGeneratorMeta idGeneratorMeta) {
        this.idGeneratorMeta = idGeneratorMeta;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isOwnProperty() {
        return this.ownProperty;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setColumnMirror(ColumnMirror columnMirror) {
        this.columnMirror = columnMirror;
    }

    public String getColumnName() {
        String columnName = this.columnMirror != null ? this.columnMirror.getNameValue() : "";
        return !columnName.isEmpty() ? columnName : this.namingType.apply(this.name);
    }

    public boolean isColumnInsertable() {
        return this.columnMirror != null ? this.columnMirror.getInsertableValue() : true;
    }

    public boolean isColumnUpdatable() {
        return this.columnMirror != null ? this.columnMirror.getUpdatableValue() : true;
    }
}

