/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.List;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameterVisitor;
import org.seasar.doma.internal.jdbc.sql.ListParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class DomainListParameter<V, D>
implements ListParameter<Wrapper<V>, D> {
    protected final String name;
    protected final List<D> domains;
    protected final DomainType<V, D> domainType;

    public DomainListParameter(DomainType<V, D> domainType, List<D> domains, String name) {
        AssertionUtil.assertNotNull(domainType, domains, (Object)name);
        this.domainType = domainType;
        this.domains = domains;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.domains;
    }

    public DomainWrapper<V, D> getWrapper() {
        return this.domainType.getWrapper(null);
    }

    @Override
    public void add(D domain) {
        this.domains.add(domain);
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CallableSqlParameterVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitDomainListParameter(this, p);
    }
}

