/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.seasar.doma.internal.jdbc.sql.BasicInOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListParameter;
import org.seasar.doma.internal.jdbc.sql.BasicListResultParameter;
import org.seasar.doma.internal.jdbc.sql.BasicOutParameter;
import org.seasar.doma.internal.jdbc.sql.BasicResultParameter;
import org.seasar.doma.internal.jdbc.sql.CallableSql;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameter;
import org.seasar.doma.internal.jdbc.sql.CallableSqlParameterVisitor;
import org.seasar.doma.internal.jdbc.sql.ConvertToLogFormatFunction;
import org.seasar.doma.internal.jdbc.sql.DomainInOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainInParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListParameter;
import org.seasar.doma.internal.jdbc.sql.DomainListResultParameter;
import org.seasar.doma.internal.jdbc.sql.DomainOutParameter;
import org.seasar.doma.internal.jdbc.sql.DomainResultParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListParameter;
import org.seasar.doma.internal.jdbc.sql.EntityListResultParameter;
import org.seasar.doma.internal.jdbc.sql.InParameter;
import org.seasar.doma.internal.jdbc.sql.ListParameter;
import org.seasar.doma.internal.jdbc.sql.MapListParameter;
import org.seasar.doma.internal.jdbc.sql.MapListResultParameter;
import org.seasar.doma.internal.jdbc.sql.OutParameter;
import org.seasar.doma.internal.jdbc.sql.ResultParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormattingFunction;
import org.seasar.doma.wrapper.Wrapper;

public class CallableSqlBuilder
implements CallableSqlParameterVisitor<Void, Context, RuntimeException> {
    protected final Config config;
    protected final SqlKind kind;
    protected final ResultParameter<?> resultParameter;
    protected final List<CallableSqlParameter> parameters;
    protected final String moduleName;
    protected final SqlLogFormattingFunction formattingFunction;
    protected boolean began;

    public CallableSqlBuilder(Config config, SqlKind kind, String moduleName, List<CallableSqlParameter> parameters) {
        this(config, kind, moduleName, parameters, null);
    }

    public CallableSqlBuilder(Config config, SqlKind kind, String moduleName, List<CallableSqlParameter> parameters, ResultParameter<?> resultParameter) {
        AssertionUtil.assertNotNull((Object)config, (Object)kind, parameters, (Object)moduleName);
        this.config = config;
        this.kind = kind;
        this.resultParameter = resultParameter;
        this.parameters = parameters;
        this.moduleName = moduleName;
        this.formattingFunction = new ConvertToLogFormatFunction();
    }

    public CallableSql build() {
        Context context = new Context();
        context.append("{");
        if (this.resultParameter != null) {
            this.resultParameter.accept(this, context);
            context.append("= ");
        }
        context.append("call ");
        context.append(this.moduleName);
        context.append("(");
        for (CallableSqlParameter parameter : this.parameters) {
            parameter.accept(this, context);
        }
        context.cutBackIfNecessary();
        context.append(")}");
        LinkedList<CallableSqlParameter> allParameters = new LinkedList<CallableSqlParameter>(this.parameters);
        if (this.resultParameter != null) {
            allParameters.addFirst(this.resultParameter);
        }
        return new CallableSql(this.kind, context.getSqlBuf(), context.getFormattedSqlBuf(), allParameters);
    }

    @Override
    public <V> Void visitBasicResultParameter(BasicResultParameter<V> parameter, Context p) throws RuntimeException {
        this.handelResultParameter(parameter, p);
        return null;
    }

    @Override
    public <V, D> Void visitDomainResultParameter(DomainResultParameter<V, D> parameter, Context p) throws RuntimeException {
        this.handelResultParameter(parameter, p);
        return null;
    }

    @Override
    public <V> Void visitBasicListResultParameter(BasicListResultParameter<V> parameter, Context p) throws RuntimeException {
        this.handelResultParameter(parameter, p);
        return null;
    }

    @Override
    public <V, D> Void visitDomainListResultParameter(DomainListResultParameter<V, D> parameter, Context p) throws RuntimeException {
        this.handelResultParameter(parameter, p);
        return null;
    }

    @Override
    public <E> Void visitEntityListResultParameter(EntityListResultParameter<E> parameter, Context p) throws RuntimeException {
        this.handelResultParameter(parameter, p);
        return null;
    }

    @Override
    public Void visitMapListResultParameter(MapListResultParameter parameter, Context p) throws RuntimeException {
        this.handelResultParameter(parameter, p);
        return null;
    }

    protected void handelResultParameter(ResultParameter<?> parameter, Context p) {
        p.appendRawSql("? ");
        p.appendFormattedSql("? ");
    }

    @Override
    public <V> Void visitBasicListParameter(BasicListParameter<V> parameter, Context p) throws RuntimeException {
        this.handelListParameter(parameter, p);
        return null;
    }

    @Override
    public <V, D> Void visitDomainListParameter(DomainListParameter<V, D> parameter, Context p) throws RuntimeException {
        this.handelListParameter(parameter, p);
        return null;
    }

    @Override
    public <E> Void visitEntityListParameter(EntityListParameter<E> parameter, Context p) throws RuntimeException {
        this.handelListParameter(parameter, p);
        return null;
    }

    @Override
    public Void visitMapListParameter(MapListParameter parameter, Context p) throws RuntimeException {
        this.handelListParameter(parameter, p);
        return null;
    }

    protected void handelListParameter(ListParameter<?, ?> parameter, Context p) {
        if (this.config.getDialect().supportsResultSetReturningAsOutParameter()) {
            p.appendRawSql("?, ");
            p.appendFormattedSql("?, ");
            p.addParameter(parameter);
        }
    }

    @Override
    public Void visitBasicInParameter(BasicInParameter parameter, Context p) throws RuntimeException {
        this.handleInParameter(parameter, parameter.getWrapper(), p);
        return null;
    }

    @Override
    public <V, D> Void visitDomainInParameter(DomainInParameter<V, D> parameter, Context p) throws RuntimeException {
        this.handleInParameter(parameter, parameter.getWrapper(), p);
        return null;
    }

    @Override
    public <V> Void visitBasicInOutParameter(BasicInOutParameter<V> parameter, Context p) throws RuntimeException {
        this.handleInParameter(parameter, parameter.getWrapper(), p);
        return null;
    }

    @Override
    public <V, D> Void visitDomainInOutParameter(DomainInOutParameter<V, D> parameter, Context p) throws RuntimeException {
        this.handleInParameter(parameter, parameter.getWrapper(), p);
        return null;
    }

    protected void handleInParameter(InParameter parameter, Wrapper<?> wrapper, Context p) {
        p.appendRawSql("?, ");
        p.appendFormattedSql(wrapper.accept(this.config.getDialect().getSqlLogFormattingVisitor(), this.formattingFunction));
        p.appendFormattedSql(", ");
        p.addParameter(parameter);
    }

    @Override
    public <V> Void visitBasicOutParameter(BasicOutParameter<V> parameter, Context p) throws RuntimeException {
        this.handleOutParameter(parameter, p);
        return null;
    }

    @Override
    public <V, D> Void visitDomainOutParameter(DomainOutParameter<V, D> parameter, Context p) throws RuntimeException {
        this.handleOutParameter(parameter, p);
        return null;
    }

    protected <V> void handleOutParameter(OutParameter<V> parameter, Context p) {
        p.appendRawSql("?, ");
        p.appendFormattedSql("?, ");
        p.addParameter(parameter);
    }

    protected class Context {
        private final StringBuilder rawSqlBuf = new StringBuilder(200);
        private final StringBuilder formattedSqlBuf = new StringBuilder(200);
        private final List<CallableSqlParameter> contextParameters = new ArrayList<CallableSqlParameter>();

        protected Context() {
        }

        protected void append(CharSequence sql) {
            this.appendRawSql(sql);
            this.appendFormattedSql(sql);
        }

        protected void cutBackIfNecessary() {
            if (!this.contextParameters.isEmpty()) {
                this.rawSqlBuf.setLength(this.rawSqlBuf.length() - 2);
                this.formattedSqlBuf.setLength(this.formattedSqlBuf.length() - 2);
            }
        }

        protected void appendRawSql(CharSequence sql) {
            this.rawSqlBuf.append(sql);
        }

        protected void appendFormattedSql(CharSequence sql) {
            this.formattedSqlBuf.append(sql);
        }

        protected CharSequence getSqlBuf() {
            return this.rawSqlBuf;
        }

        protected CharSequence getFormattedSqlBuf() {
            return this.formattedSqlBuf;
        }

        protected void addParameter(CallableSqlParameter parameter) {
            this.contextParameters.add(parameter);
        }

        public String toString() {
            return this.rawSqlBuf.toString();
        }
    }
}

