/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import org.seasar.doma.internal.apt.meta.IdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.IdGeneratorMetaVisitor;
import org.seasar.doma.internal.apt.mirror.TableGeneratorMirror;
import org.seasar.doma.internal.util.AssertionUtil;

public class TableIdGeneratorMeta
implements IdGeneratorMeta {
    protected final TableGeneratorMirror tableGeneratorMirror;

    public TableIdGeneratorMeta(TableGeneratorMirror tableGeneratorMirror) {
        AssertionUtil.assertNotNull(tableGeneratorMirror);
        this.tableGeneratorMirror = tableGeneratorMirror;
    }

    public String getQualifiedTableName() {
        String schemaName;
        StringBuilder buf = new StringBuilder();
        String catalogName = this.tableGeneratorMirror.getCatalogValue();
        if (!catalogName.isEmpty()) {
            buf.append(catalogName);
            buf.append(".");
        }
        if (!(schemaName = this.tableGeneratorMirror.getCatalogValue()).isEmpty()) {
            buf.append(schemaName);
            buf.append(".");
        }
        buf.append(this.tableGeneratorMirror.getTableValue());
        return buf.toString();
    }

    public String getPkColumnName() {
        return this.tableGeneratorMirror.getPkColumnNameValue();
    }

    public String getValueColumnName() {
        return this.tableGeneratorMirror.getValueColumnNameValue();
    }

    public String getPkColumnValue() {
        return this.tableGeneratorMirror.getPkColumnValueValue();
    }

    public long getInitialValue() {
        return this.tableGeneratorMirror.getInitialValueValue();
    }

    public long getAllocationSize() {
        return this.tableGeneratorMirror.getAllocationSizeValue();
    }

    @Override
    public String getIdGeneratorClassName() {
        return ((Object)this.tableGeneratorMirror.getImplementerValue()).toString();
    }

    @Override
    public <R, P> R accept(IdGeneratorMetaVisitor<R, P> visitor, P p) {
        return visitor.visistTableIdGeneratorMeta(this, p);
    }
}

