/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.internal.jdbc.sql.BasicInParameter;
import org.seasar.doma.internal.jdbc.sql.ConvertToLogFormatFunction;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormattingFunction;
import org.seasar.doma.wrapper.Wrapper;

public class PreparedSqlBuilder {
    protected final List<BasicInParameter> parameters = new ArrayList<BasicInParameter>();
    protected final StringBuilder rawSql = new StringBuilder(200);
    protected final StringBuilder formattedSql = new StringBuilder(200);
    protected final Config config;
    protected final SqlKind kind;
    protected final SqlLogFormattingFunction formattingFunction;

    public PreparedSqlBuilder(Config config, SqlKind kind) {
        AssertionUtil.assertNotNull((Object)config, (Object)kind);
        this.config = config;
        this.kind = kind;
        this.formattingFunction = new ConvertToLogFormatFunction();
    }

    public void appendSql(String sql) {
        this.rawSql.append(sql);
        this.formattedSql.append(sql);
    }

    public void cutBackSql(int length) {
        this.rawSql.setLength(this.rawSql.length() - length);
        this.formattedSql.setLength(this.formattedSql.length() - length);
    }

    public void appendWrapper(Wrapper<?> wrapper) {
        this.rawSql.append("?");
        this.formattedSql.append(wrapper.accept(this.config.getDialect().getSqlLogFormattingVisitor(), this.formattingFunction));
        this.parameters.add(new BasicInParameter(wrapper));
    }

    public PreparedSql build() {
        return new PreparedSql(this.kind, this.rawSql, this.formattedSql, null, this.parameters);
    }
}

