/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.util;

import java.io.File;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.dialect.Dialect;

final class FileUtil {
    FileUtil() {
    }

    static String buildPath(String prefix, String suffix, String className, String methodName) {
        AssertionUtil.assertNotNull((Object)prefix, (Object)suffix, (Object)className, (Object)methodName);
        String path = FileUtil.buildPath(prefix, suffix, className);
        path = path + "/" + methodName + suffix;
        return path;
    }

    static String buildPath(String prefix, String suffix, String className) {
        AssertionUtil.assertNotNull((Object)prefix, (Object)suffix, (Object)className);
        int pos = className.lastIndexOf(".");
        String packageName = pos > 0 ? className.substring(0, pos) : null;
        String simpleName = pos > 0 ? className.substring(pos + 1) : className;
        String path = prefix;
        if (pos > 0) {
            path = path + packageName.replace(".", "/") + "/";
        }
        path = path + simpleName;
        return path;
    }

    static boolean isFile(String prefix, String suffix, File file, String methodName) {
        AssertionUtil.assertNotNull((Object)prefix, (Object)suffix, (Object)file, (Object)methodName);
        if (!file.isFile()) {
            return false;
        }
        String fileName = file.getName();
        return fileName.equals(methodName + suffix) || fileName.startsWith(methodName + "-") && fileName.endsWith(suffix);
    }

    static String convertToDbmsSpecificPath(String prefix, String suffix, String path, Dialect dialect) {
        AssertionUtil.assertNotNull((Object)prefix, (Object)suffix, (Object)path, (Object)dialect);
        String name = dialect.getName();
        return path.substring(0, path.length() - suffix.length()) + "-" + name + suffix;
    }
}

