/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingFunction;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.wrapper.Wrapper;

public class SetValueFunction
implements JdbcMappingFunction {
    protected final PreparedStatement preparedStatement;
    protected final int index;

    public SetValueFunction(PreparedStatement preparedStatement, int index) {
        AssertionUtil.assertNotNull(preparedStatement);
        AssertionUtil.assertTrue(index > 0, index);
        this.preparedStatement = preparedStatement;
        this.index = index;
    }

    @Override
    public <R, V> R apply(Wrapper<V> wrapper, JdbcType<V> jdbcType) throws SQLException {
        if (wrapper == null) {
            throw new DomaNullPointerException("wrapper");
        }
        if (jdbcType == null) {
            throw new DomaNullPointerException("jdbcType");
        }
        jdbcType.setValue(this.preparedStatement, this.index, wrapper.get());
        return null;
    }
}

