/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.requests;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.junit.internal.runners.CompositeRunner;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.internal.runners.InitializationError;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorReportingRequest
extends Request {
    private final Class<?> fClass;
    private final Throwable fCause;

    public ErrorReportingRequest(Class<?> klass, Throwable cause) {
        this.fClass = klass;
        this.fCause = cause;
    }

    @Override
    public Runner getRunner() {
        List<Throwable> goofs = this.getCauses(this.fCause);
        CompositeRunner runner = new CompositeRunner(this.fClass.getName());
        for (int i = 0; i < goofs.size(); ++i) {
            Description description = Description.createTestDescription(this.fClass, "initializationError" + i);
            Throwable throwable = goofs.get(i);
            runner.add(new ErrorReportingRunner(description, throwable));
        }
        return runner;
    }

    private List<Throwable> getCauses(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            return this.getCauses(cause.getCause());
        }
        if (cause instanceof InitializationError) {
            return ((InitializationError)cause).getCauses();
        }
        return Arrays.asList(cause);
    }
}

