/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import org.seasar.doma.internal.jdbc.sql.CallableSqlParameterVisitor;
import org.seasar.doma.internal.jdbc.sql.ResultParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.wrapper.Wrapper;

public class BasicResultParameter<V>
implements ResultParameter<V> {
    protected final Wrapper<V> wrapper;
    protected final boolean primitveResult;

    public BasicResultParameter(Wrapper<V> wrapper, boolean primitveResult) {
        AssertionUtil.assertNotNull(wrapper);
        if (primitveResult) {
            AssertionUtil.assertNotNull(wrapper.getDefault());
        }
        this.wrapper = wrapper;
        this.primitveResult = primitveResult;
    }

    @Override
    public Object getValue() {
        return this.wrapper.get();
    }

    public Wrapper<V> getWrapper() {
        return this.wrapper;
    }

    @Override
    public V getResult() {
        V result = this.wrapper.get();
        if (result == null && this.primitveResult) {
            result = this.wrapper.getDefault();
            AssertionUtil.assertNotNull(result);
        }
        return result;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CallableSqlParameterVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitBasicResultParameter(this, p);
    }
}

