/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalOptionException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.AptTypeHandleException;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.TypeElementHandler;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractProcessor
extends javax.annotation.processing.AbstractProcessor {
    protected AbstractProcessor() {
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    protected void handleTypeElement(TypeElement typeElement, TypeElementHandler handler) {
        if (Options.isDebugEnabled(this.processingEnv)) {
            Notifier.debug(this.processingEnv, Message.DOMA4090, this.getClass().getName(), typeElement.getQualifiedName());
        }
        try {
            handler.handle(typeElement);
        }
        catch (AptException e) {
            Notifier.notify(this.processingEnv, e);
        }
        catch (AptIllegalOptionException e) {
            Notifier.notify(this.processingEnv, Diagnostic.Kind.ERROR, e.getMessage(), typeElement);
            throw new AptTypeHandleException(typeElement, (Throwable)e);
        }
        catch (AptIllegalStateException e) {
            Notifier.notify(this.processingEnv, Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4039, typeElement, new Object[0]);
            throw new AptTypeHandleException(typeElement, (Throwable)e);
        }
        catch (RuntimeException e) {
            Notifier.notify(this.processingEnv, Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4016, typeElement, new Object[0]);
            throw new AptTypeHandleException(typeElement, (Throwable)e);
        }
        if (Options.isDebugEnabled(this.processingEnv)) {
            Notifier.debug(this.processingEnv, Message.DOMA4091, this.getClass().getName(), typeElement.getQualifiedName());
        }
    }
}

