/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.TransactionStore;
import org.h2.mvstore.db.MVTable;
import org.h2.table.TableBase;
import org.h2.util.New;

public class MVTableEngine
implements TableEngine {
    static final Map<String, Store> STORES = new WeakHashMap<String, Store>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush(Database database) {
        String string = database.getDatabasePath();
        if (string == null) {
            return;
        }
        Map<String, Store> map = STORES;
        synchronized (map) {
            Store store = STORES.get(string);
            if (store == null) {
                return;
            }
            MVTableEngine.store(store.getStore());
        }
    }

    public static Collection<Store> getStores() {
        return STORES.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableBase createTable(CreateTableData createTableData) {
        Object object;
        Store store;
        Database database = createTableData.session.getDatabase();
        byte[] byArray = database.getFilePasswordHash();
        String string = database.getDatabasePath();
        MVStore.Builder builder = new MVStore.Builder();
        if (string == null) {
            store = new Store(database, builder.open());
        } else {
            object = STORES;
            synchronized (object) {
                store = STORES.get(string);
                if (store == null) {
                    builder.fileName(string + ".mv.db");
                    if (database.isReadOnly()) {
                        builder.readOnly();
                    }
                    if (byArray != null) {
                        char[] cArray = new char[byArray.length];
                        for (int i = 0; i < byArray.length; ++i) {
                            cArray[i] = (char)byArray[i];
                        }
                        builder.encryptionKey(cArray);
                    }
                    store = new Store(database, builder.open());
                    STORES.put(string, store);
                } else if (store.db != database) {
                    throw DbException.get(90020, string);
                }
            }
        }
        object = new MVTable(createTableData, string, store.getTransactionStore());
        store.openTables.add((MVTable)object);
        ((MVTable)object).init(createTableData.session);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeTable(String string, MVTable mVTable) {
        Map<String, Store> map = STORES;
        synchronized (map) {
            Store store = STORES.get(string);
            if (store != null) {
                store.openTables.remove(mVTable);
                if (store.openTables.size() == 0) {
                    MVTableEngine.store(store.getStore());
                    store.getStore().close();
                    STORES.remove(string);
                }
            }
        }
    }

    static void store(MVStore mVStore) {
        mVStore.compact(50);
        mVStore.store();
    }

    public static class Store {
        final Database db;
        final ArrayList<MVTable> openTables = New.arrayList();
        private final MVStore store;
        private final TransactionStore transactionStore;

        public Store(Database database, MVStore mVStore) {
            this.db = database;
            this.store = mVStore;
            this.transactionStore = new TransactionStore(mVStore);
        }

        public MVStore getStore() {
            return this.store;
        }

        public TransactionStore getTransactionStore() {
            return this.transactionStore;
        }
    }
}

