/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import org.seasar.doma.internal.apt.AbstractGenerator;
import org.seasar.doma.internal.apt.meta.ExternalDomainMeta;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.MetaUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainWrapper;

public class ExternalDomainTypeGenerator
extends AbstractGenerator {
    protected final ExternalDomainMeta domainMeta;
    protected final String domainTypeName;
    protected final String metaTypeName;
    protected final String simpleMetaTypeName;
    protected final String typeParamDecl;
    protected final boolean parametarized;

    public ExternalDomainTypeGenerator(ProcessingEnvironment env, TypeElement typeElement, ExternalDomainMeta domainMeta) throws IOException {
        super(env, typeElement, "__." + ElementUtil.getPackageName(typeElement, env), null, "_", "");
        AssertionUtil.assertNotNull(domainMeta);
        this.domainMeta = domainMeta;
        this.domainTypeName = TypeMirrorUtil.getTypeName(domainMeta.getDomainElement().asType(), env);
        this.metaTypeName = MetaUtil.getMetaTypeName(this.domainTypeName);
        this.simpleMetaTypeName = MetaUtil.getSimpleMetaTypeName(this.domainTypeName);
        this.typeParamDecl = this.makeTypeParamDecl(this.domainTypeName);
        this.parametarized = !domainMeta.getDomainElement().getTypeParameters().isEmpty();
    }

    private String makeTypeParamDecl(String typeName) {
        int pos = typeName.indexOf("<");
        if (pos == -1) {
            return "";
        }
        return typeName.substring(pos);
    }

    @Override
    public void generate() {
        this.printPackage();
        this.printClass();
    }

    protected void printPackage() {
        if (!this.packageName.isEmpty()) {
            this.iprint("package %1$s;%n", this.packageName);
            this.iprint("%n", new Object[0]);
        }
    }

    protected void printClass() {
        if (this.domainMeta.getDomainElement().getTypeParameters().isEmpty()) {
            this.iprint("/** */%n", new Object[0]);
        } else {
            this.iprint("/**%n", new Object[0]);
            for (TypeParameterElement typeParameterElement : this.domainMeta.getDomainElement().getTypeParameters()) {
                this.iprint(" * @param <%1$s> %1$s%n", typeParameterElement.getSimpleName());
            }
            this.iprint(" */%n", new Object[0]);
        }
        this.printGenerated();
        this.iprint("public final class %1$s implements %2$s<%3$s, %4$s> {%n", this.simpleMetaTypeName, DomainType.class.getName(), this.domainMeta.getValueElement().getQualifiedName(), this.domainTypeName);
        this.print("%n", new Object[0]);
        this.indent();
        this.printValidateVersionStaticInitializer();
        this.printFields();
        this.printConstructors();
        this.printMethods();
        this.unindent();
        this.unindent();
        this.iprint("}%n", new Object[0]);
    }

    protected void printFields() {
        if (this.parametarized) {
            this.iprint("@SuppressWarnings(\"rawtypes\")%n", new Object[0]);
        }
        this.iprint("private static final %1$s singleton = new %1$s();%n", this.simpleName);
        this.print("%n", new Object[0]);
        this.iprint("private static final %1$s converter = new %1$s();%n", this.domainMeta.getTypeElement().getQualifiedName());
        this.print("%n", new Object[0]);
    }

    protected void printConstructors() {
        this.iprint("private %1$s() {%n", this.simpleName);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printMethods() {
        this.printNewDomainMethod();
        this.printGetValueClassMethod();
        this.printGetDomainClassMethod();
        this.printGetWrapperMethod();
        this.printGetSingletonInternalMethod();
        this.printWrapperClass();
    }

    protected void printNewDomainMethod() {
        if (this.parametarized) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s newDomain(%2$s value) {%n", this.domainTypeName, this.domainMeta.getValueElement().getQualifiedName());
        if (this.parametarized) {
            this.iprint("    return (%1$s) converter.fromValueToDomain(value);%n", this.domainTypeName);
        } else {
            this.iprint("    return converter.fromValueToDomain(value);%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetValueClassMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getValueClass() {%n", this.domainMeta.getValueElement().getQualifiedName());
        this.iprint("    return %1$s.class;%n", this.domainMeta.getValueElement().getQualifiedName());
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetDomainClassMethod() {
        if (this.parametarized) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
        }
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public Class<%1$s> getDomainClass() {%n", this.domainTypeName);
        if (this.parametarized) {
            this.iprint("    Class<?> clazz = %1$s.class;%n", this.domainMeta.getDomainElement().getQualifiedName());
            this.iprint("    return (Class<%1$s>) clazz;%n", this.domainTypeName);
        } else {
            this.iprint("    return %1$s.class;%n", this.domainMeta.getDomainElement().getQualifiedName());
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetWrapperMethod() {
        this.iprint("@Override%n", new Object[0]);
        this.iprint("public %1$s<%2$s, %3$s> getWrapper(%3$s domain) {%n", DomainWrapper.class.getName(), this.domainMeta.getValueElement().getQualifiedName(), this.domainTypeName);
        this.iprint("    return new Wrapper%1$s(domain);%n", this.typeParamDecl);
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printGetSingletonInternalMethod() {
        this.iprint("/**%n", new Object[0]);
        this.iprint(" * @return the singleton%n", new Object[0]);
        this.iprint(" */%n", new Object[0]);
        if (this.parametarized) {
            this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
            this.iprint("public static %1$s %2$s getSingletonInternal() {%n", this.typeParamDecl, this.simpleMetaTypeName);
            this.iprint("    return (%1$s) singleton;%n", this.simpleMetaTypeName);
        } else {
            this.iprint("public static %1$s getSingletonInternal() {%n", this.simpleMetaTypeName);
            this.iprint("    return singleton;%n", new Object[0]);
        }
        this.iprint("}%n", new Object[0]);
        this.print("%n", new Object[0]);
    }

    protected void printWrapperClass() {
        WrapperGenerator wrapperGenerator = this.createWrapperGenerator();
        wrapperGenerator.generate();
    }

    protected WrapperGenerator createWrapperGenerator() {
        return new WrapperGenerator();
    }

    protected class WrapperGenerator {
        protected WrapperGenerator() {
        }

        protected void generate() {
            ExternalDomainTypeGenerator.this.iprint("private static class Wrapper%1$s extends %2$s implements %3$s<%4$s, %5$s> {%n", ExternalDomainTypeGenerator.this.typeParamDecl, ExternalDomainTypeGenerator.this.domainMeta.getWrapperType().getTypeName(), DomainWrapper.class.getName(), ExternalDomainTypeGenerator.this.domainMeta.getValueElement().getQualifiedName(), ExternalDomainTypeGenerator.this.domainTypeName);
            ExternalDomainTypeGenerator.this.print("%n", new Object[0]);
            ExternalDomainTypeGenerator.this.indent();
            this.printWrapperField();
            this.printWrapperConstructor();
            this.printWrapperDoGetMethod();
            this.pirntWrapperDoSetMethod();
            this.printWrapperGetDomainMethod();
            ExternalDomainTypeGenerator.this.unindent();
            ExternalDomainTypeGenerator.this.iprint("}%n", new Object[0]);
        }

        protected void printWrapperField() {
            ExternalDomainTypeGenerator.this.iprint("private %1$s domain;%n", ExternalDomainTypeGenerator.this.domainTypeName);
            ExternalDomainTypeGenerator.this.print("%n", new Object[0]);
        }

        protected void printWrapperConstructor() {
            ExternalDomainTypeGenerator.this.iprint("private Wrapper(%1$s domain) {%n", ExternalDomainTypeGenerator.this.domainTypeName);
            if (ExternalDomainTypeGenerator.this.domainMeta.getWrapperType().getWrappedType().isEnum()) {
                ExternalDomainTypeGenerator.this.iprint("    super(%1$s.class);%n", ExternalDomainTypeGenerator.this.domainMeta.getValueElement().getQualifiedName());
            }
            ExternalDomainTypeGenerator.this.iprint("    this.domain = domain;%n", new Object[0]);
            ExternalDomainTypeGenerator.this.iprint("}%n", new Object[0]);
            ExternalDomainTypeGenerator.this.print("%n", new Object[0]);
        }

        protected void printWrapperDoGetMethod() {
            ExternalDomainTypeGenerator.this.iprint("@Override%n", new Object[0]);
            ExternalDomainTypeGenerator.this.iprint("protected %1$s doGet() {%n", ExternalDomainTypeGenerator.this.domainMeta.getValueElement().getQualifiedName());
            ExternalDomainTypeGenerator.this.iprint("    if (domain == null) {%n", new Object[0]);
            ExternalDomainTypeGenerator.this.iprint("        return null;%n", new Object[0]);
            ExternalDomainTypeGenerator.this.iprint("    }%n", new Object[0]);
            ExternalDomainTypeGenerator.this.iprint("    return converter.fromDomainToValue(domain);%n", new Object[0]);
            ExternalDomainTypeGenerator.this.iprint("}%n", new Object[0]);
            ExternalDomainTypeGenerator.this.print("%n", new Object[0]);
        }

        protected void pirntWrapperDoSetMethod() {
            if (ExternalDomainTypeGenerator.this.parametarized) {
                ExternalDomainTypeGenerator.this.iprint("@SuppressWarnings(\"unchecked\")%n", new Object[0]);
            }
            ExternalDomainTypeGenerator.this.iprint("@Override%n", new Object[0]);
            ExternalDomainTypeGenerator.this.iprint("protected void doSet(%1$s value) {%n", ExternalDomainTypeGenerator.this.domainMeta.getValueElement().getQualifiedName());
            if (ExternalDomainTypeGenerator.this.parametarized) {
                ExternalDomainTypeGenerator.this.iprint("    domain = (%1$s) converter.fromValueToDomain(value);%n", ExternalDomainTypeGenerator.this.domainTypeName);
            } else {
                ExternalDomainTypeGenerator.this.iprint("    domain = converter.fromValueToDomain(value);%n", new Object[0]);
            }
            ExternalDomainTypeGenerator.this.iprint("}%n", new Object[0]);
            ExternalDomainTypeGenerator.this.print("%n", new Object[0]);
        }

        protected void printWrapperGetDomainMethod() {
            ExternalDomainTypeGenerator.this.iprint("@Override%n", new Object[0]);
            ExternalDomainTypeGenerator.this.iprint("public %1$s getDomain() {%n", ExternalDomainTypeGenerator.this.domainTypeName);
            ExternalDomainTypeGenerator.this.iprint("    return domain;%n", new Object[0]);
            ExternalDomainTypeGenerator.this.iprint("}%n", new Object[0]);
        }
    }
}

