/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.jdbc.type.AbstractJdbcType;

public class FloatType
extends AbstractJdbcType<Float> {
    public FloatType() {
        super(6);
    }

    @Override
    public Float doGetValue(ResultSet resultSet, int index) throws SQLException {
        return Float.valueOf(resultSet.getFloat(index));
    }

    @Override
    protected void doSetValue(PreparedStatement preparedStatement, int index, Float value) throws SQLException {
        preparedStatement.setDouble(index, value.floatValue());
    }

    @Override
    protected Float doGetValue(CallableStatement callableStatement, int index) throws SQLException {
        return Float.valueOf(callableStatement.getFloat(index));
    }

    @Override
    protected String doConvertToLogFormat(Float value) {
        return String.valueOf(value);
    }
}

