/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dao;

import java.lang.reflect.Method;
import java.sql.Connection;
import javax.sql.DataSource;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.RuntimeConfig;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.jdbc.dao.NeverClosedConnection;
import org.seasar.doma.internal.jdbc.dao.NeverClosedConnectionProvider;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.internal.util.MethodUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ConfigException;
import org.seasar.doma.jdbc.DaoMethodNotFoundException;

public abstract class AbstractDao {
    protected final Config config;

    protected AbstractDao(Config config) {
        if (config == null) {
            new DomaNullPointerException("config");
        }
        this.validateConfig(config, null);
        this.config = new RuntimeConfig(config, config.getDataSource());
    }

    protected AbstractDao(Config config, Connection connection) {
        if (config == null) {
            new DomaNullPointerException("config");
        }
        if (connection == null) {
            new DomaNullPointerException("connection");
        }
        NeverClosedConnectionProvider dataSource = null;
        dataSource = connection instanceof NeverClosedConnection ? new NeverClosedConnectionProvider((NeverClosedConnection)connection) : new NeverClosedConnectionProvider(new NeverClosedConnection(connection));
        this.validateConfig(config, dataSource);
        this.config = new RuntimeConfig(config, dataSource);
    }

    protected AbstractDao(Config config, DataSource dataSource) {
        if (config == null) {
            new DomaNullPointerException("config");
        }
        if (dataSource == null) {
            new DomaNullPointerException("dataSource");
        }
        this.validateConfig(config, dataSource);
        this.config = new RuntimeConfig(config, dataSource);
    }

    private void validateConfig(Config config, DataSource dataSource) {
        if (dataSource == null && config.getDataSource() == null) {
            throw new ConfigException(config.getClass().getName(), "getDataSource");
        }
        if (config.getDialect() == null) {
            throw new ConfigException(config.getClass().getName(), "getDialect");
        }
        if (config.getSqlFileRepository() == null) {
            throw new ConfigException(config.getClass().getName(), "getSqlFileRepository");
        }
        if (config.getJdbcLogger() == null) {
            throw new ConfigException(config.getClass().getName(), "getJdbcLogger");
        }
        if (config.getExceptionSqlLogType() == null) {
            throw new ConfigException(config.getClass().getName(), "getExceptionSqlLogType");
        }
    }

    protected DataSource getDataSource() {
        return this.config.getDataSource();
    }

    protected void entering(String callerClassName, String callerMethodName, Object ... args) {
        this.config.getJdbcLogger().logDaoMethodEntering(callerClassName, callerMethodName, args);
    }

    protected void exiting(String callerClassName, String callerMethodName, Object result) {
        this.config.getJdbcLogger().logDaoMethodExiting(callerClassName, callerMethodName, result);
    }

    protected void throwing(String callerClassName, String callerMethodName, RuntimeException e) {
        this.config.getJdbcLogger().logDaoMethodThrowing(callerClassName, callerMethodName, e);
    }

    public static <T> Method __getDeclaredMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return ClassUtil.getDeclaredMethod(clazz, name, parameterTypes);
        }
        catch (WrapException e) {
            String signature = MethodUtil.createSignature(name, parameterTypes);
            throw new DaoMethodNotFoundException(e.getCause(), clazz.getName(), signature);
        }
    }
}

