/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingFunction;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.wrapper.Wrapper;

public class RegisterOutParameterFunction
implements JdbcMappingFunction {
    protected final CallableStatement callableStatement;
    protected final int index;

    public RegisterOutParameterFunction(CallableStatement callableStatement, int index) {
        AssertionUtil.assertNotNull(callableStatement);
        AssertionUtil.assertTrue(index > 0, index);
        this.callableStatement = callableStatement;
        this.index = index;
    }

    @Override
    public <R, V> R apply(Wrapper<V> wrapper, JdbcType<V> jdbcType) throws SQLException {
        if (jdbcType == null) {
            throw new DomaNullPointerException("jdbcType");
        }
        jdbcType.registerOutParameter(this.callableStatement, this.index);
        return null;
    }
}

