/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.seasar.aptina.commons.util.AssertionUtils;
import org.seasar.aptina.commons.util.CollectionUtils;
import org.seasar.aptina.commons.util.ElementUtils;

public class TypeMirrorUtils {
    public static final Map<String, TypeKind> PRIMITIVE_TYPES;

    private TypeMirrorUtils() {
    }

    public static TypeMirror getTypeMirror(Types typeUtils, Elements elementUtils, Class<?> clazz) {
        AssertionUtils.assertNotNull("typeUtils", typeUtils);
        AssertionUtils.assertNotNull("elementUtils", elementUtils);
        AssertionUtils.assertNotNull("clazz", clazz);
        if (clazz.isArray()) {
            return TypeMirrorUtils.toArrayType(typeUtils, TypeMirrorUtils.getTypeMirror(typeUtils, elementUtils, clazz.getComponentType()));
        }
        return TypeMirrorUtils.getTypeMirror(typeUtils, elementUtils, clazz.getName());
    }

    public static TypeMirror getTypeMirror(Types typeUtils, Elements elementUtils, String className) {
        AssertionUtils.assertNotNull("typeUtils", typeUtils);
        AssertionUtils.assertNotNull("elementUtils", elementUtils);
        AssertionUtils.assertNotEmpty("className", className);
        if (className.endsWith("[]")) {
            String componentTypeName = className.substring(0, className.length() - 2);
            return TypeMirrorUtils.toArrayType(typeUtils, TypeMirrorUtils.getTypeMirror(typeUtils, elementUtils, componentTypeName));
        }
        if (className.startsWith("[") && className.endsWith(";")) {
            int pos = className.indexOf("L");
            String componentTypeName = className.substring(pos + 1, className.length() - 1);
            TypeMirror typeMirror = TypeMirrorUtils.getTypeMirror(typeUtils, elementUtils, componentTypeName);
            for (int i = 0; i < pos; ++i) {
                typeMirror = TypeMirrorUtils.toArrayType(typeUtils, typeMirror);
            }
            return typeMirror;
        }
        if (PRIMITIVE_TYPES.containsKey(className)) {
            TypeKind typeKind = PRIMITIVE_TYPES.get(className);
            return typeUtils.getPrimitiveType(typeKind);
        }
        TypeElement typeElement = ElementUtils.getTypeElement(elementUtils, className);
        if (typeElement == null) {
            return null;
        }
        return typeElement.asType();
    }

    public static TypeMirror toArrayType(Types typeUtils, TypeMirror componentTypeMirror) {
        if (componentTypeMirror == null) {
            return null;
        }
        return typeUtils.getArrayType(componentTypeMirror);
    }

    public static List<TypeMirror> toTypeMirrors(Types typeUtils, Elements elementUtils, Class<?> ... types) throws IllegalArgumentException {
        AssertionUtils.assertNotNull("typeUtils", typeUtils);
        AssertionUtils.assertNotNull("elementUtils", elementUtils);
        AssertionUtils.assertNotNull("types", types);
        List<TypeMirror> typeMirrors = CollectionUtils.newArrayList();
        for (Class<?> type : types) {
            TypeMirror typeMirror = TypeMirrorUtils.getTypeMirror(typeUtils, elementUtils, type);
            if (typeMirror == null) {
                throw new IllegalArgumentException("unknown type : " + type);
            }
            typeMirrors.add(typeMirror);
        }
        return typeMirrors;
    }

    public static List<TypeMirror> toTypeMirrors(Types typeUtils, Elements elementUtils, String ... typeNames) {
        AssertionUtils.assertNotNull("typeUtils", typeUtils);
        AssertionUtils.assertNotNull("elementUtils", elementUtils);
        AssertionUtils.assertNotNull("typeNames", typeNames);
        List<TypeMirror> typeMirrors = CollectionUtils.newArrayList();
        for (String typeName : typeNames) {
            TypeMirror typeMirror = TypeMirrorUtils.getTypeMirror(typeUtils, elementUtils, typeName);
            if (typeMirror == null) {
                throw new IllegalArgumentException("unknown type : " + typeName);
            }
            typeMirrors.add(typeMirror);
        }
        return typeMirrors;
    }

    public static List<String> toTypeNameList(List<? extends TypeMirror> typeMirrors) {
        List<String> result = CollectionUtils.newArrayList();
        for (TypeMirror typeMirror : typeMirrors) {
            result.add(((Object)typeMirror).toString());
        }
        return result;
    }

    static {
        Map<String, TypeKind> map = CollectionUtils.newHashMap();
        map.put(Void.TYPE.getName(), TypeKind.VOID);
        map.put(Boolean.TYPE.getName(), TypeKind.BOOLEAN);
        map.put(Character.TYPE.getName(), TypeKind.CHAR);
        map.put(Byte.TYPE.getName(), TypeKind.BYTE);
        map.put(Short.TYPE.getName(), TypeKind.SHORT);
        map.put(Integer.TYPE.getName(), TypeKind.INT);
        map.put(Long.TYPE.getName(), TypeKind.LONG);
        map.put(Float.TYPE.getName(), TypeKind.FLOAT);
        map.put(Double.TYPE.getName(), TypeKind.DOUBLE);
        PRIMITIVE_TYPES = Collections.unmodifiableMap(map);
    }
}

