/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.AssertionUtil;

public final class ClassUtil {
    public static <T> T newInstance(Class<T> clazz) throws WrapException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new WrapException(e);
        }
        catch (IllegalAccessException e) {
            throw new WrapException(e);
        }
    }

    @Deprecated
    public static <T> T newInstance(String name) throws WrapException {
        Class<T> clazz = ClassUtil.forName(name);
        return ClassUtil.newInstance(clazz);
    }

    @Deprecated
    public static <T> Class<T> forName(String name) throws WrapException {
        try {
            Class<?> clazz = Class.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new WrapException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws WrapException {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            throw new WrapException(e);
        }
        catch (NoSuchMethodException e) {
            throw new WrapException(e);
        }
    }

    public static <T> Method getMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) throws WrapException {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            throw new WrapException(e);
        }
        catch (NoSuchMethodException e) {
            throw new WrapException(e);
        }
    }

    public static <T> Method getDeclaredMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) throws WrapException {
        AssertionUtil.assertNotNull(clazz, (Object)name, parameterTypes);
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            throw new WrapException(e);
        }
        catch (NoSuchMethodException e) {
            throw new WrapException(e);
        }
    }

    public static <T> Field getDeclaredField(Class<T> clazz, String name) throws WrapException {
        AssertionUtil.assertNotNull(clazz, (Object)name);
        try {
            return clazz.getDeclaredField(name);
        }
        catch (SecurityException e) {
            throw new WrapException(e);
        }
        catch (NoSuchFieldException e) {
            throw new WrapException(e);
        }
    }

    public static String getPackageName(String qualifiedName) {
        AssertionUtil.assertNotNull(qualifiedName);
        int pos = qualifiedName.lastIndexOf(46);
        if (pos < 0) {
            return "";
        }
        return qualifiedName.substring(0, pos);
    }

    public static String getSimpleName(String qualifiedName) {
        AssertionUtil.assertNotNull(qualifiedName);
        int pos = qualifiedName.lastIndexOf(46);
        if (pos < 0) {
            return qualifiedName;
        }
        return qualifiedName.substring(pos + 1);
    }

    public static Class<?> toBoxedPrimitiveTypeIfPossible(Class<?> clazz) {
        AssertionUtil.assertNotNull(clazz);
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }
}

