/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import java.util.Collections;
import java.util.List;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlKind;

public class PreparedSql
implements Sql<PreparedSqlParameter> {
    protected final SqlKind kind;
    protected final String rawSql;
    protected final String formattedSql;
    protected final String sqlFilePath;
    protected final List<PreparedSqlParameter> parameters;

    public PreparedSql(SqlKind kind, CharSequence rawSql, CharSequence formattedSql, String sqlFilePath, List<? extends PreparedSqlParameter> parameters) {
        if (kind == null) {
            throw new DomaNullPointerException("kind");
        }
        if (rawSql == null) {
            throw new DomaNullPointerException("rawSql");
        }
        if (formattedSql == null) {
            throw new DomaNullPointerException("formattedSql");
        }
        if (parameters == null) {
            throw new DomaNullPointerException("parameters");
        }
        this.kind = kind;
        this.rawSql = ((Object)rawSql).toString().trim();
        this.formattedSql = ((Object)formattedSql).toString().trim();
        this.sqlFilePath = sqlFilePath;
        this.parameters = Collections.unmodifiableList(parameters);
    }

    @Override
    public SqlKind getKind() {
        return this.kind;
    }

    @Override
    public String getRawSql() {
        return this.rawSql;
    }

    @Override
    public String getFormattedSql() {
        return this.formattedSql;
    }

    @Override
    public String getSqlFilePath() {
        return this.sqlFilePath;
    }

    @Override
    public List<PreparedSqlParameter> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.rawSql;
    }
}

