/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.util;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.internal.util.MethodUtil;

public final class ConnectionUtil {
    public static void setSchema(Connection connection, String schema) throws SQLException {
        try {
            Method method = ClassUtil.getMethod(Connection.class, "setSchema", String.class);
            MethodUtil.invoke(method, connection, schema);
        }
        catch (WrapException e) {
            throw new SQLException(e.getCause());
        }
    }

    public static String getSchema(Connection connection) throws SQLException {
        try {
            Method method = ClassUtil.getMethod(Connection.class, "getSchema", new Class[0]);
            return (String)MethodUtil.invoke(method, connection, new Object[0]);
        }
        catch (WrapException e) {
            throw new SQLException(e.getCause());
        }
    }

    public static void abort(Connection connection, Executor executor) throws SQLException {
        try {
            Method method = ClassUtil.getMethod(Connection.class, "abort", Executor.class);
            MethodUtil.invoke(method, connection, executor);
        }
        catch (WrapException e) {
            throw new SQLException(e.getCause());
        }
    }

    public static void setNetworkTimeout(Connection connection, Executor executor, int milliseconds) throws SQLException {
        try {
            Method method = ClassUtil.getMethod(Connection.class, "setNetworkTimeout", Executor.class, Integer.TYPE);
            MethodUtil.invoke(method, connection, executor, milliseconds);
        }
        catch (WrapException e) {
            throw new SQLException(e.getCause());
        }
    }

    public static int getNetworkTimeout(Connection connection) throws SQLException {
        try {
            Method method = ClassUtil.getMethod(Connection.class, "getNetworkTimeout", new Class[0]);
            Integer result = (Integer)MethodUtil.invoke(method, connection, new Object[0]);
            return result;
        }
        catch (WrapException e) {
            throw new SQLException(e.getCause());
        }
    }
}

