/*
 * Copyright 2004-2009 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.doma.it;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

import org.seasar.extension.dbcp.ConnectionWrapper;

public class ItConnection implements Connection {

    protected final ConnectionWrapper connectionWrapper;

    public ItConnection(ConnectionWrapper connectionWrapper)
            throws SQLException {
        this.connectionWrapper = connectionWrapper;
    }

    public void clearWarnings() throws SQLException {
        connectionWrapper.clearWarnings();
    }

    public void close() throws SQLException {
        connectionWrapper.close();
    }

    public void commit() throws SQLException {
        connectionWrapper.commit();
    }

    public Statement createStatement() throws SQLException {
        return connectionWrapper.createStatement();
    }

    public Statement createStatement(int resultSetType,
            int resultSetConcurrency, int resultSetHoldability)
            throws SQLException {
        return connectionWrapper.createStatement(resultSetType,
                resultSetConcurrency, resultSetHoldability);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency)
            throws SQLException {
        return connectionWrapper.createStatement(resultSetType,
                resultSetConcurrency);
    }

    public String getCatalog() throws SQLException {
        return connectionWrapper.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return connectionWrapper.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return connectionWrapper.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return connectionWrapper.getTransactionIsolation();
    }

    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return connectionWrapper.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return connectionWrapper.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return connectionWrapper.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return connectionWrapper.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        return connectionWrapper.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType,
            int resultSetConcurrency, int resultSetHoldability)
            throws SQLException {
        return connectionWrapper.prepareCall(sql, resultSetType,
                resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType,
            int resultSetConcurrency) throws SQLException {
        return connectionWrapper.prepareCall(sql, resultSetType,
                resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return connectionWrapper.prepareCall(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType,
            int resultSetConcurrency, int resultSetHoldability)
            throws SQLException {
        return connectionWrapper.prepareStatement(sql, resultSetType,
                resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType,
            int resultSetConcurrency) throws SQLException {
        return connectionWrapper.prepareStatement(sql, resultSetType,
                resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)
            throws SQLException {
        return connectionWrapper.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes)
            throws SQLException {
        return connectionWrapper.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames)
            throws SQLException {
        return connectionWrapper.prepareStatement(sql, columnNames);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return connectionWrapper.prepareStatement(sql);
    }

    public void release() throws SQLException {
        connectionWrapper.release();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        connectionWrapper.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        connectionWrapper.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        connectionWrapper.rollback(savepoint);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        connectionWrapper.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        connectionWrapper.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        connectionWrapper.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        connectionWrapper.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        return connectionWrapper.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return connectionWrapper.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        connectionWrapper.setTransactionIsolation(level);
    }

    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        connectionWrapper.setTypeMap(map);
    }

    public Array createArrayOf(String typeName, Object[] elements)
            throws SQLException {
        try {
            return getPhysicalConnection().createArrayOf(typeName, elements);
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public Blob createBlob() throws SQLException {
        try {
            return getPhysicalConnection().createBlob();
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public Clob createClob() throws SQLException {
        try {
            return getPhysicalConnection().createClob();
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public NClob createNClob() throws SQLException {
        try {
            return getPhysicalConnection().createNClob();
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public SQLXML createSQLXML() throws SQLException {
        try {
            return getPhysicalConnection().createSQLXML();
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public Struct createStruct(String typeName, Object[] attributes)
            throws SQLException {
        try {
            return getPhysicalConnection().createStruct(typeName, attributes);
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return getPhysicalConnection().getAutoCommit();
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public Properties getClientInfo() throws SQLException {
        try {
            return getPhysicalConnection().getClientInfo();
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public String getClientInfo(String name) throws SQLException {
        try {
            return getPhysicalConnection().getClientInfo(name);
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public boolean isValid(int timeout) throws SQLException {
        try {
            return getPhysicalConnection().isValid(timeout);
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return getPhysicalConnection().isWrapperFor(iface);
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    public void setClientInfo(Properties properties)
            throws SQLClientInfoException {
        try {
            getPhysicalConnection().setClientInfo(properties);
        } catch (SQLException e) {
            try {
                connectionWrapper.release();
            } catch (SQLException sqlException) {
                throw new SQLClientInfoException(Collections
                        .<String, ClientInfoStatus> emptyMap(), e);
            }
            throw new SQLClientInfoException(Collections
                    .<String, ClientInfoStatus> emptyMap(), e);
        }
    }

    public void setClientInfo(String name, String value)
            throws SQLClientInfoException {
        try {
            getPhysicalConnection().setClientInfo(name, value);
        } catch (SQLException e) {
            try {
                connectionWrapper.release();
            } catch (SQLException sqlException) {
                throw new SQLClientInfoException(Collections
                        .<String, ClientInfoStatus> emptyMap(), e);
            }
            throw new SQLClientInfoException(Collections
                    .<String, ClientInfoStatus> emptyMap(), e);
        }
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return getPhysicalConnection().unwrap(iface);
        } catch (SQLException e) {
            release();
            throw e;
        }
    }

    protected Connection getPhysicalConnection() {
        return connectionWrapper.getPhysicalConnection();
    }

}
