/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.sql.Statement;
import java.util.Map;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.GenerationType;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.entity.BasicPropertyType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.jdbc.id.IdGenerator;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;
import org.seasar.doma.wrapper.NumberWrapper;

public class GeneratedIdPropertyType<PE, E extends PE, V extends Number, D>
extends BasicPropertyType<PE, E, V, D> {
    protected final IdGenerator idGenerator;

    public GeneratedIdPropertyType(Class<E> entityClass, Class<V> entityPropertyClass, Class<? extends NumberWrapper<V>> wrapperClass, EntityPropertyType<PE, V> parentEntityPropertyType, DomainType<V, D> domainType, String name, String columnName, IdGenerator idGenerator) {
        super(entityClass, entityPropertyClass, wrapperClass, parentEntityPropertyType, domainType, name, columnName, true, true);
        if (idGenerator == null) {
            throw new DomaNullPointerException("idGenerator");
        }
        this.idGenerator = idGenerator;
    }

    @Override
    public boolean isId() {
        return true;
    }

    public void validateGenerationStrategy(IdGenerationConfig config) {
        Dialect dialect = config.getDialect();
        GenerationType generationType = this.idGenerator.getGenerationType();
        if (!this.isGenerationTypeSupported(generationType, dialect)) {
            EntityType<?> entityType = config.getEntityType();
            throw new JdbcException((MessageResource)Message.DOMA2021, entityType.getName(), this.name, generationType.name(), dialect.getName());
        }
    }

    protected boolean isGenerationTypeSupported(GenerationType generationType, Dialect dialect) {
        switch (generationType) {
            case IDENTITY: {
                return dialect.supportsIdentity();
            }
            case SEQUENCE: {
                return dialect.supportsSequence();
            }
        }
        return true;
    }

    public boolean isIncluded(IdGenerationConfig config) {
        return this.idGenerator.includesIdentityColumn(config);
    }

    public boolean isBatchSupported(IdGenerationConfig config) {
        return this.idGenerator.supportsBatch(config);
    }

    public boolean isAutoGeneratedKeysSupported(IdGenerationConfig config) {
        return this.idGenerator.supportsAutoGeneratedKeys(config);
    }

    public void preInsert(E entity, IdGenerationConfig config) {
        Long value = this.idGenerator.generatePreInsert(config);
        if (value != null) {
            NumberWrapper wrapper = (NumberWrapper)this.getWrapper(entity);
            wrapper.set(value);
        }
    }

    public E preInsertAndNewEntity(E entity, IdGenerationConfig config, EntityType<E> entityType) {
        Long value = this.idGenerator.generatePreInsert(config);
        if (value != null) {
            return this.newEntity(entity, value, entityType);
        }
        return null;
    }

    public void postInsert(E entity, IdGenerationConfig config, Statement statement) {
        Long value = this.idGenerator.generatePostInsert(config, statement);
        if (value != null) {
            NumberWrapper wrapper = (NumberWrapper)this.getWrapper(entity);
            wrapper.set(value);
        }
    }

    public E postInsertAndNewEntity(E entity, IdGenerationConfig config, Statement statement, EntityType<E> entityType) {
        Long value = this.idGenerator.generatePostInsert(config, statement);
        if (value != null) {
            return this.newEntity(entity, value, entityType);
        }
        return null;
    }

    protected E newEntity(E entity, Long value, EntityType<E> entityType) {
        Map<String, Object> properties = entityType.getCopy(entity);
        NumberWrapper setter = (NumberWrapper)this.getWrapper(properties);
        setter.set(value);
        return entityType.newEntity(properties);
    }
}

