/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.Delegate;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class DelegateMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue to;

    protected DelegateMirror(AnnotationMirror annotationMirror) {
        AssertionUtil.assertNotNull(annotationMirror);
        this.annotationMirror = annotationMirror;
    }

    public static DelegateMirror newInstance(ExecutableElement method, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror(method, Delegate.class, env);
        if (annotationMirror == null) {
            return null;
        }
        DelegateMirror result = new DelegateMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if (!"to".equals(name)) continue;
            result.to = value;
        }
        return result;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public AnnotationValue getTo() {
        return this.to;
    }

    public TypeMirror getToValue() {
        TypeMirror result = AnnotationValueUtil.toType(this.to);
        if (result == null) {
            throw new AptIllegalStateException("to");
        }
        return result;
    }
}

