/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.SpaceStrippingNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class ElseNode
extends AbstractSqlNode
implements SpaceStrippingNode {
    protected final String text;

    public ElseNode(String text) {
        AssertionUtil.assertNotNull(text);
        this.text = text;
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public ElseNode copy() {
        ElseNode clone = new ElseNode(this.text);
        for (SqlNode child : this.children) {
            clone.addNode(child.copy());
        }
        return clone;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof ElseNodeVisitor) {
            ElseNodeVisitor v = (ElseNodeVisitor)visitor;
            return v.visitElseNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        buf.append(this.text);
        for (SqlNode child : this.children) {
            buf.append(child);
        }
        buf.append("]");
        return buf.toString();
    }
}

