/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.util.Map;
import org.seasar.doma.internal.expr.ExpressionEvaluator;
import org.seasar.doma.internal.expr.Value;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.NodePreparedSqlBuilder;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlNode;

public class CountQuery
implements SelectQuery {
    protected Config config;
    protected Map<String, Value> parameters;
    protected String callerClassName;
    protected String callerMethodName;
    protected SqlNode sqlNode;
    protected PreparedSql sql;
    protected SelectOptions options;
    protected int fetchSize;
    protected int maxRows;
    protected int queryTimeout;

    @Override
    public boolean isResultEnsured() {
        return true;
    }

    @Override
    public boolean isResultMappingEnsured() {
        return false;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public SelectOptions getOptions() {
        return this.options;
    }

    @Override
    public PreparedSql getSql() {
        return this.sql;
    }

    @Override
    public String getClassName() {
        return this.callerClassName;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public String getMethodName() {
        return this.callerMethodName;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void prepare() {
        SqlNode transformedSqlNode = this.config.getDialect().transformSelectSqlNodeForGettingCount(this.sqlNode);
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this.parameters, this.config.getDialect().getExpressionFunctions(), this.config.getClassHelper());
        NodePreparedSqlBuilder sqlBuilder = new NodePreparedSqlBuilder(this.config, SqlKind.SELECT, null, evaluator);
        this.sql = sqlBuilder.build(transformedSqlNode);
    }

    @Override
    public void complete() {
    }
}

