/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.IfNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.SpaceStrippingNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class IfNode
extends AbstractSqlNode
implements SpaceStrippingNode {
    protected final SqlLocation location;
    protected final String expression;
    protected final String text;

    public IfNode(SqlLocation location, String expression, String text) {
        AssertionUtil.assertNotNull((Object)location, (Object)expression, (Object)text);
        this.location = location;
        this.expression = expression;
        this.text = text;
    }

    public SqlLocation getLocation() {
        return this.location;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public IfNode copy() {
        IfNode clone = new IfNode(this.location, this.expression, this.text);
        for (SqlNode child : this.children) {
            clone.addNode(child.copy());
        }
        return clone;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof IfNodeVisitor) {
            IfNodeVisitor v = (IfNodeVisitor)visitor;
            return v.visitIfNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        buf.append(this.text);
        for (SqlNode child : this.children) {
            buf.append(child);
        }
        buf.append("]");
        return buf.toString();
    }
}

