/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.internal.apt.AbstractProcessor;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Generator;
import org.seasar.doma.internal.apt.TypeElementHandler;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.util.IOUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractGeneratingProcessor<M extends TypeElementMeta>
extends AbstractProcessor {
    protected AbstractGeneratingProcessor() {
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            final TypeElementMetaFactory<M> factory = this.createTypeElementMetaFactory();
            TypeElementHandler handler = new TypeElementHandler(){

                @Override
                public void handle(TypeElement typeElement) {
                    Object meta = factory.createTypeElementMeta(typeElement);
                    if (!meta.isError()) {
                        AbstractGeneratingProcessor.this.generate(typeElement, meta);
                    }
                }
            };
            for (TypeElement typeElement2 : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement))) {
                this.handleTypeElement(typeElement2, handler);
            }
        }
        return true;
    }

    protected abstract TypeElementMetaFactory<M> createTypeElementMetaFactory();

    protected void generate(TypeElement typeElement, M meta) {
        Generator generator = null;
        try {
            generator = this.createGenerator(typeElement, meta);
            generator.generate();
        }
        catch (IOException e) {
            try {
                throw new AptException((MessageResource)Message.DOMA4011, this.processingEnv, (Element)typeElement, e, typeElement.getQualifiedName(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(generator);
                throw throwable;
            }
        }
        IOUtil.close(generator);
    }

    protected abstract Generator createGenerator(TypeElement var1, M var2) throws IOException;
}

