/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.lang.reflect.Method;
import java.sql.Statement;
import org.seasar.doma.internal.jdbc.entity.AbstractPostInsertContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreInsertContext;
import org.seasar.doma.internal.jdbc.query.BatchInsertQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileBatchModifyQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;

public class SqlFileBatchInsertQuery<E>
extends SqlFileBatchModifyQuery<E>
implements BatchInsertQuery {
    protected EntityHandler entityHandler;

    public SqlFileBatchInsertQuery(Class<E> elementClass) {
        super(elementClass, SqlKind.BATCH_INSERT);
    }

    @Override
    public void prepare() {
        super.prepare();
        int size = this.elements.size();
        if (size == 0) {
            return;
        }
        this.executable = true;
        this.sqlExecutionSkipCause = null;
        this.currentEntity = this.elements.get(0);
        this.preInsert();
        this.prepareSqlFile();
        this.prepareOptions();
        this.prepareSql();
        this.elements.set(0, this.currentEntity);
        for (int i = 1; i < size; ++i) {
            this.currentEntity = this.elements.get(i);
            this.preInsert();
            this.prepareSql();
            this.elements.set(i, this.currentEntity);
        }
        AssertionUtil.assertEquals(size, this.sqls.size());
    }

    protected void preInsert() {
        if (this.entityHandler != null) {
            this.entityHandler.preInsert();
        }
    }

    @Override
    public void generateId(Statement statement, int index) {
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            int len = this.elements.size();
            for (int i = 0; i < len; ++i) {
                this.currentEntity = this.elements.get(i);
                this.entityHandler.postInsert();
                this.elements.set(i, this.currentEntity);
            }
        }
    }

    @Override
    public void setEntityType(EntityType<E> entityType) {
        this.entityHandler = new EntityHandler(entityType);
    }

    @Override
    public boolean isBatchSupported() {
        return true;
    }

    protected static class SqlFileBatchPostInsertContext<E>
    extends AbstractPostInsertContext<E> {
        public SqlFileBatchPostInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class SqlFileBatchPreInsertContext<E>
    extends AbstractPreInsertContext<E> {
        public SqlFileBatchPreInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected class EntityHandler {
        protected EntityType<E> entityType;

        protected EntityHandler(EntityType<E> entityType) {
            AssertionUtil.assertNotNull(entityType);
            this.entityType = entityType;
        }

        protected void preInsert() {
            SqlFileBatchPreInsertContext context = new SqlFileBatchPreInsertContext(this.entityType, SqlFileBatchInsertQuery.this.method, SqlFileBatchInsertQuery.this.config);
            this.entityType.preInsert(SqlFileBatchInsertQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchInsertQuery.this.currentEntity = context.getNewEntity();
            }
        }

        protected void postInsert() {
            SqlFileBatchPostInsertContext context = new SqlFileBatchPostInsertContext(this.entityType, SqlFileBatchInsertQuery.this.method, SqlFileBatchInsertQuery.this.config);
            this.entityType.postInsert(SqlFileBatchInsertQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchInsertQuery.this.currentEntity = context.getNewEntity();
            }
        }
    }
}

