/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.type;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.type.AbstractDataType;
import org.seasar.doma.internal.apt.type.AnyType;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.DataTypeVisitor;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.MapType;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class IterableType
extends AbstractDataType {
    protected TypeMirror elementTypeMirror;
    protected DataType elementType;

    public IterableType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public boolean isRawType() {
        return this.elementTypeMirror == null;
    }

    public boolean isWildcardType() {
        return this.elementTypeMirror != null && this.elementTypeMirror.getKind() == TypeKind.WILDCARD;
    }

    public boolean isList() {
        return TypeMirrorUtil.isSameType(this.typeMirror, List.class, this.env);
    }

    public static IterableType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        TypeMirror supertype = TypeMirrorUtil.getSupertypeMirror(type, Iterable.class, env);
        if (supertype == null) {
            return null;
        }
        IterableType iterableType = new IterableType(type, env);
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(supertype, env);
        if (declaredType == null) {
            return null;
        }
        List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
        if (typeArgs.size() > 0) {
            iterableType.elementTypeMirror = typeArgs.get(0);
            iterableType.elementType = EntityType.newInstance(iterableType.elementTypeMirror, env);
            if (iterableType.elementType == null) {
                iterableType.elementType = DomainType.newInstance(iterableType.elementTypeMirror, env);
                if (iterableType.elementType == null) {
                    iterableType.elementType = BasicType.newInstance(iterableType.elementTypeMirror, env);
                    if (iterableType.elementType == null) {
                        iterableType.elementType = MapType.newInstance(iterableType.elementTypeMirror, env);
                        if (iterableType.elementType == null) {
                            iterableType.elementType = AnyType.newInstance(iterableType.elementTypeMirror, env);
                        }
                    }
                }
            }
        }
        return iterableType;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(DataTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitIterableType(this, p);
    }
}

