/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.doma.internal.apt.meta;

import static org.seasar.doma.internal.util.AssertionUtil.*;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

/**
 * 
 * @author taedium
 * 
 */
public class OriginalStatesMeta {

    protected final TypeElement typeElement;

    protected final VariableElement fieldElement;

    protected final TypeElement fieldEnclosingElement;

    public OriginalStatesMeta(TypeElement typeElement,
            VariableElement fieldElement, TypeElement fieldEnclosingElement,
            ProcessingEnvironment env) {
        assertNotNull(typeElement, fieldElement, fieldEnclosingElement, env);
        this.typeElement = typeElement;
        this.fieldElement = fieldElement;
        this.fieldEnclosingElement = fieldEnclosingElement;
    }

    public TypeElement getTypeElement() {
        return typeElement;
    }

    public VariableElement getFieldElement() {
        return fieldElement;
    }

    public TypeElement getFieldEnclosingElement() {
        return fieldEnclosingElement;
    }

}
