/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.EolNodeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class EolNode
extends AbstractSqlNode {
    protected final String eol;

    public EolNode(String eol) {
        AssertionUtil.assertNotNull(eol);
        this.eol = eol;
    }

    public String getEol() {
        return this.eol;
    }

    @Override
    public void addNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    @Override
    public EolNode copy() {
        return this;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof EolNodeVisitor) {
            EolNodeVisitor v = (EolNodeVisitor)visitor;
            return v.visitEolNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        buf.append("]");
        return buf.toString();
    }
}

